<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CMFTToken StructType
 * @subpackage Structs
 */
class CMFTToken extends Token
{
    /**
     * The Cipher1
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\STS1Token
     */
    public $Cipher1;
    /**
     * The Cipher2
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\STS1Token
     */
    public $Cipher2;
    /**
     * Constructor method for CMFTToken
     * @uses CMFTToken::setCipher1()
     * @uses CMFTToken::setCipher2()
     * @param \StructType\STS1Token $cipher1
     * @param \StructType\STS1Token $cipher2
     */
    public function __construct(\StructType\STS1Token $cipher1 = null, \StructType\STS1Token $cipher2 = null)
    {
        $this
            ->setCipher1($cipher1)
            ->setCipher2($cipher2);
    }
    /**
     * Get Cipher1 value
     * @return \StructType\STS1Token|null
     */
    public function getCipher1()
    {
        return $this->Cipher1;
    }
    /**
     * Set Cipher1 value
     * @param \StructType\STS1Token $cipher1
     * @return \StructType\CMFTToken
     */
    public function setCipher1(\StructType\STS1Token $cipher1 = null)
    {
        $this->Cipher1 = $cipher1;
        return $this;
    }
    /**
     * Get Cipher2 value
     * @return \StructType\STS1Token|null
     */
    public function getCipher2()
    {
        return $this->Cipher2;
    }
    /**
     * Set Cipher2 value
     * @param \StructType\STS1Token $cipher2
     * @return \StructType\CMFTToken
     */
    public function setCipher2(\StructType\STS1Token $cipher2 = null)
    {
        $this->Cipher2 = $cipher2;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\CMFTToken
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
