<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BatchReport StructType
 * @subpackage Structs
 */
class BatchReport extends AbstractStructBase
{
    /**
     * The txTotal
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\TxTotal[]
     */
    public $txTotal;
    /**
     * The operatorTotal
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\OperatorTotal[]
     */
    public $operatorTotal;
    /**
     * The payTypeTotal
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\PayTypeTotal[]
     */
    public $payTypeTotal;
    /**
     * The resTot
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\ResourceTotal[]
     */
    public $resTot;
    /**
     * Constructor method for BatchReport
     * @uses BatchReport::setTxTotal()
     * @uses BatchReport::setOperatorTotal()
     * @uses BatchReport::setPayTypeTotal()
     * @uses BatchReport::setResTot()
     * @param \StructType\TxTotal[] $txTotal
     * @param \StructType\OperatorTotal[] $operatorTotal
     * @param \StructType\PayTypeTotal[] $payTypeTotal
     * @param \StructType\ResourceTotal[] $resTot
     */
    public function __construct(array $txTotal = array(), array $operatorTotal = array(), array $payTypeTotal = array(), array $resTot = array())
    {
        $this
            ->setTxTotal($txTotal)
            ->setOperatorTotal($operatorTotal)
            ->setPayTypeTotal($payTypeTotal)
            ->setResTot($resTot);
    }
    /**
     * Get txTotal value
     * @return \StructType\TxTotal[]|null
     */
    public function getTxTotal()
    {
        return $this->txTotal;
    }
    /**
     * Set txTotal value
     * @throws \InvalidArgumentException
     * @param \StructType\TxTotal[] $txTotal
     * @return \StructType\BatchReport
     */
    public function setTxTotal(array $txTotal = array())
    {
        foreach ($txTotal as $batchReportTxTotalItem) {
            // validation for constraint: itemType
            if (!$batchReportTxTotalItem instanceof \StructType\TxTotal) {
                throw new \InvalidArgumentException(sprintf('The txTotal property can only contain items of \StructType\TxTotal, "%s" given', is_object($batchReportTxTotalItem) ? get_class($batchReportTxTotalItem) : gettype($batchReportTxTotalItem)), __LINE__);
            }
        }
        $this->txTotal = $txTotal;
        return $this;
    }
    /**
     * Add item to txTotal value
     * @throws \InvalidArgumentException
     * @param \StructType\TxTotal $item
     * @return \StructType\BatchReport
     */
    public function addToTxTotal(\StructType\TxTotal $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\TxTotal) {
            throw new \InvalidArgumentException(sprintf('The txTotal property can only contain items of \StructType\TxTotal, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->txTotal[] = $item;
        return $this;
    }
    /**
     * Get operatorTotal value
     * @return \StructType\OperatorTotal[]|null
     */
    public function getOperatorTotal()
    {
        return $this->operatorTotal;
    }
    /**
     * Set operatorTotal value
     * @throws \InvalidArgumentException
     * @param \StructType\OperatorTotal[] $operatorTotal
     * @return \StructType\BatchReport
     */
    public function setOperatorTotal(array $operatorTotal = array())
    {
        foreach ($operatorTotal as $batchReportOperatorTotalItem) {
            // validation for constraint: itemType
            if (!$batchReportOperatorTotalItem instanceof \StructType\OperatorTotal) {
                throw new \InvalidArgumentException(sprintf('The operatorTotal property can only contain items of \StructType\OperatorTotal, "%s" given', is_object($batchReportOperatorTotalItem) ? get_class($batchReportOperatorTotalItem) : gettype($batchReportOperatorTotalItem)), __LINE__);
            }
        }
        $this->operatorTotal = $operatorTotal;
        return $this;
    }
    /**
     * Add item to operatorTotal value
     * @throws \InvalidArgumentException
     * @param \StructType\OperatorTotal $item
     * @return \StructType\BatchReport
     */
    public function addToOperatorTotal(\StructType\OperatorTotal $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\OperatorTotal) {
            throw new \InvalidArgumentException(sprintf('The operatorTotal property can only contain items of \StructType\OperatorTotal, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->operatorTotal[] = $item;
        return $this;
    }
    /**
     * Get payTypeTotal value
     * @return \StructType\PayTypeTotal[]|null
     */
    public function getPayTypeTotal()
    {
        return $this->payTypeTotal;
    }
    /**
     * Set payTypeTotal value
     * @throws \InvalidArgumentException
     * @param \StructType\PayTypeTotal[] $payTypeTotal
     * @return \StructType\BatchReport
     */
    public function setPayTypeTotal(array $payTypeTotal = array())
    {
        foreach ($payTypeTotal as $batchReportPayTypeTotalItem) {
            // validation for constraint: itemType
            if (!$batchReportPayTypeTotalItem instanceof \StructType\PayTypeTotal) {
                throw new \InvalidArgumentException(sprintf('The payTypeTotal property can only contain items of \StructType\PayTypeTotal, "%s" given', is_object($batchReportPayTypeTotalItem) ? get_class($batchReportPayTypeTotalItem) : gettype($batchReportPayTypeTotalItem)), __LINE__);
            }
        }
        $this->payTypeTotal = $payTypeTotal;
        return $this;
    }
    /**
     * Add item to payTypeTotal value
     * @throws \InvalidArgumentException
     * @param \StructType\PayTypeTotal $item
     * @return \StructType\BatchReport
     */
    public function addToPayTypeTotal(\StructType\PayTypeTotal $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\PayTypeTotal) {
            throw new \InvalidArgumentException(sprintf('The payTypeTotal property can only contain items of \StructType\PayTypeTotal, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->payTypeTotal[] = $item;
        return $this;
    }
    /**
     * Get resTot value
     * @return \StructType\ResourceTotal[]|null
     */
    public function getResTot()
    {
        return $this->resTot;
    }
    /**
     * Set resTot value
     * @throws \InvalidArgumentException
     * @param \StructType\ResourceTotal[] $resTot
     * @return \StructType\BatchReport
     */
    public function setResTot(array $resTot = array())
    {
        foreach ($resTot as $batchReportResTotItem) {
            // validation for constraint: itemType
            if (!$batchReportResTotItem instanceof \StructType\ResourceTotal) {
                throw new \InvalidArgumentException(sprintf('The resTot property can only contain items of \StructType\ResourceTotal, "%s" given', is_object($batchReportResTotItem) ? get_class($batchReportResTotItem) : gettype($batchReportResTotItem)), __LINE__);
            }
        }
        $this->resTot = $resTot;
        return $this;
    }
    /**
     * Add item to resTot value
     * @throws \InvalidArgumentException
     * @param \StructType\ResourceTotal $item
     * @return \StructType\BatchReport
     */
    public function addToResTot(\StructType\ResourceTotal $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ResourceTotal) {
            throw new \InvalidArgumentException(sprintf('The resTot property can only contain items of \StructType\ResourceTotal, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->resTot[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\BatchReport
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
