<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BaseResp StructType
 * @subpackage Structs
 */
class BaseResp extends AbstractStructBase
{
    /**
     * The respDateTime
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $respDateTime;
    /**
     * The clientID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\DeviceID
     */
    public $clientID;
    /**
     * The serverID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\DeviceID
     */
    public $serverID;
    /**
     * The terminalID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\DeviceID
     */
    public $terminalID;
    /**
     * The reqMsgID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\MsgID
     */
    public $reqMsgID;
    /**
     * The dispHeader
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $dispHeader;
    /**
     * The operatorMsg
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $operatorMsg;
    /**
     * The custMsg
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $custMsg;
    /**
     * The utility
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\UtilityDetail
     */
    public $utility;
    /**
     * Constructor method for BaseResp
     * @uses BaseResp::setRespDateTime()
     * @uses BaseResp::setClientID()
     * @uses BaseResp::setServerID()
     * @uses BaseResp::setTerminalID()
     * @uses BaseResp::setReqMsgID()
     * @uses BaseResp::setDispHeader()
     * @uses BaseResp::setOperatorMsg()
     * @uses BaseResp::setCustMsg()
     * @uses BaseResp::setUtility()
     * @param string $respDateTime
     * @param \StructType\DeviceID $clientID
     * @param \StructType\DeviceID $serverID
     * @param \StructType\DeviceID $terminalID
     * @param \StructType\MsgID $reqMsgID
     * @param string $dispHeader
     * @param string $operatorMsg
     * @param string $custMsg
     * @param \StructType\UtilityDetail $utility
     */
    public function __construct($respDateTime = null, \StructType\DeviceID $clientID = null, \StructType\DeviceID $serverID = null, \StructType\DeviceID $terminalID = null, \StructType\MsgID $reqMsgID = null, $dispHeader = null, $operatorMsg = null, $custMsg = null, \StructType\UtilityDetail $utility = null)
    {
        $this
            ->setRespDateTime($respDateTime)
            ->setClientID($clientID)
            ->setServerID($serverID)
            ->setTerminalID($terminalID)
            ->setReqMsgID($reqMsgID)
            ->setDispHeader($dispHeader)
            ->setOperatorMsg($operatorMsg)
            ->setCustMsg($custMsg)
            ->setUtility($utility);
    }
    /**
     * Get respDateTime value
     * @return string
     */
    public function getRespDateTime()
    {
        return $this->respDateTime;
    }
    /**
     * Set respDateTime value
     * @param string $respDateTime
     * @return \StructType\BaseResp
     */
    public function setRespDateTime($respDateTime = null)
    {
        // validation for constraint: string
        if (!is_null($respDateTime) && !is_string($respDateTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($respDateTime)), __LINE__);
        }
        $this->respDateTime = $respDateTime;
        return $this;
    }
    /**
     * Get clientID value
     * @return \StructType\DeviceID|null
     */
    public function getClientID()
    {
        return $this->clientID;
    }
    /**
     * Set clientID value
     * @param \StructType\DeviceID $clientID
     * @return \StructType\BaseResp
     */
    public function setClientID(\StructType\DeviceID $clientID = null)
    {
        $this->clientID = $clientID;
        return $this;
    }
    /**
     * Get serverID value
     * @return \StructType\DeviceID|null
     */
    public function getServerID()
    {
        return $this->serverID;
    }
    /**
     * Set serverID value
     * @param \StructType\DeviceID $serverID
     * @return \StructType\BaseResp
     */
    public function setServerID(\StructType\DeviceID $serverID = null)
    {
        $this->serverID = $serverID;
        return $this;
    }
    /**
     * Get terminalID value
     * @return \StructType\DeviceID|null
     */
    public function getTerminalID()
    {
        return $this->terminalID;
    }
    /**
     * Set terminalID value
     * @param \StructType\DeviceID $terminalID
     * @return \StructType\BaseResp
     */
    public function setTerminalID(\StructType\DeviceID $terminalID = null)
    {
        $this->terminalID = $terminalID;
        return $this;
    }
    /**
     * Get reqMsgID value
     * @return \StructType\MsgID|null
     */
    public function getReqMsgID()
    {
        return $this->reqMsgID;
    }
    /**
     * Set reqMsgID value
     * @param \StructType\MsgID $reqMsgID
     * @return \StructType\BaseResp
     */
    public function setReqMsgID(\StructType\MsgID $reqMsgID = null)
    {
        $this->reqMsgID = $reqMsgID;
        return $this;
    }
    /**
     * Get dispHeader value
     * @return string|null
     */
    public function getDispHeader()
    {
        return $this->dispHeader;
    }
    /**
     * Set dispHeader value
     * @param string $dispHeader
     * @return \StructType\BaseResp
     */
    public function setDispHeader($dispHeader = null)
    {
        // validation for constraint: string
        if (!is_null($dispHeader) && !is_string($dispHeader)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($dispHeader)), __LINE__);
        }
        $this->dispHeader = $dispHeader;
        return $this;
    }
    /**
     * Get operatorMsg value
     * @return string|null
     */
    public function getOperatorMsg()
    {
        return $this->operatorMsg;
    }
    /**
     * Set operatorMsg value
     * @param string $operatorMsg
     * @return \StructType\BaseResp
     */
    public function setOperatorMsg($operatorMsg = null)
    {
        // validation for constraint: string
        if (!is_null($operatorMsg) && !is_string($operatorMsg)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($operatorMsg)), __LINE__);
        }
        $this->operatorMsg = $operatorMsg;
        return $this;
    }
    /**
     * Get custMsg value
     * @return string|null
     */
    public function getCustMsg()
    {
        return $this->custMsg;
    }
    /**
     * Set custMsg value
     * @param string $custMsg
     * @return \StructType\BaseResp
     */
    public function setCustMsg($custMsg = null)
    {
        // validation for constraint: string
        if (!is_null($custMsg) && !is_string($custMsg)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($custMsg)), __LINE__);
        }
        $this->custMsg = $custMsg;
        return $this;
    }
    /**
     * Get utility value
     * @return \StructType\UtilityDetail|null
     */
    public function getUtility()
    {
        return $this->utility;
    }
    /**
     * Set utility value
     * @param \StructType\UtilityDetail $utility
     * @return \StructType\BaseResp
     */
    public function setUtility(\StructType\UtilityDetail $utility = null)
    {
        $this->utility = $utility;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\BaseResp
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
