<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BaseReq StructType
 * @subpackage Structs
 */
class BaseReq extends AbstractStructBase
{
    /**
     * The clientID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\DeviceID
     */
    public $clientID;
    /**
     * The terminalID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\DeviceID
     */
    public $terminalID;
    /**
     * The msgID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\MsgID
     */
    public $msgID;
    /**
     * The authCred
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\AuthCred
     */
    public $authCred;
    /**
     * Constructor method for BaseReq
     * @uses BaseReq::setClientID()
     * @uses BaseReq::setTerminalID()
     * @uses BaseReq::setMsgID()
     * @uses BaseReq::setAuthCred()
     * @param \StructType\DeviceID $clientID
     * @param \StructType\DeviceID $terminalID
     * @param \StructType\MsgID $msgID
     * @param \StructType\AuthCred $authCred
     */
    public function __construct(\StructType\DeviceID $clientID = null, \StructType\DeviceID $terminalID = null, \StructType\MsgID $msgID = null, \StructType\AuthCred $authCred = null)
    {
        $this
            ->setClientID($clientID)
            ->setTerminalID($terminalID)
            ->setMsgID($msgID)
            ->setAuthCred($authCred);
    }
    /**
     * Get clientID value
     * @return \StructType\DeviceID|null
     */
    public function getClientID()
    {
        return $this->clientID;
    }
    /**
     * Set clientID value
     * @param \StructType\DeviceID $clientID
     * @return \StructType\BaseReq
     */
    public function setClientID(\StructType\DeviceID $clientID = null)
    {
        $this->clientID = $clientID;
        return $this;
    }
    /**
     * Get terminalID value
     * @return \StructType\DeviceID|null
     */
    public function getTerminalID()
    {
        return $this->terminalID;
    }
    /**
     * Set terminalID value
     * @param \StructType\DeviceID $terminalID
     * @return \StructType\BaseReq
     */
    public function setTerminalID(\StructType\DeviceID $terminalID = null)
    {
        $this->terminalID = $terminalID;
        return $this;
    }
    /**
     * Get msgID value
     * @return \StructType\MsgID|null
     */
    public function getMsgID()
    {
        return $this->msgID;
    }
    /**
     * Set msgID value
     * @param \StructType\MsgID $msgID
     * @return \StructType\BaseReq
     */
    public function setMsgID(\StructType\MsgID $msgID = null)
    {
        $this->msgID = $msgID;
        return $this;
    }
    /**
     * Get authCred value
     * @return \StructType\AuthCred|null
     */
    public function getAuthCred()
    {
        return $this->authCred;
    }
    /**
     * Set authCred value
     * @param \StructType\AuthCred $authCred
     * @return \StructType\BaseReq
     */
    public function setAuthCred(\StructType\AuthCred $authCred = null)
    {
        $this->authCred = $authCred;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\BaseReq
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
