<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BankStartBatch StructType
 * @subpackage Structs
 */
class BankStartBatch extends StartBatch
{
    /**
     * The salesStartBatch
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SalesStartBatch[]
     */
    public $salesStartBatch;
    /**
     * The seqNo
     * @var string
     */
    public $seqNo;
    /**
     * Constructor method for BankStartBatch
     * @uses BankStartBatch::setSalesStartBatch()
     * @uses BankStartBatch::setSeqNo()
     * @param \StructType\SalesStartBatch[] $salesStartBatch
     * @param string $seqNo
     */
    public function __construct(array $salesStartBatch = array(), $seqNo = null)
    {
        $this
            ->setSalesStartBatch($salesStartBatch)
            ->setSeqNo($seqNo);
    }
    /**
     * Get salesStartBatch value
     * @return \StructType\SalesStartBatch[]|null
     */
    public function getSalesStartBatch()
    {
        return $this->salesStartBatch;
    }
    /**
     * Set salesStartBatch value
     * @throws \InvalidArgumentException
     * @param \StructType\SalesStartBatch[] $salesStartBatch
     * @return \StructType\BankStartBatch
     */
    public function setSalesStartBatch(array $salesStartBatch = array())
    {
        foreach ($salesStartBatch as $bankStartBatchSalesStartBatchItem) {
            // validation for constraint: itemType
            if (!$bankStartBatchSalesStartBatchItem instanceof \StructType\SalesStartBatch) {
                throw new \InvalidArgumentException(sprintf('The salesStartBatch property can only contain items of \StructType\SalesStartBatch, "%s" given', is_object($bankStartBatchSalesStartBatchItem) ? get_class($bankStartBatchSalesStartBatchItem) : gettype($bankStartBatchSalesStartBatchItem)), __LINE__);
            }
        }
        $this->salesStartBatch = $salesStartBatch;
        return $this;
    }
    /**
     * Add item to salesStartBatch value
     * @throws \InvalidArgumentException
     * @param \StructType\SalesStartBatch $item
     * @return \StructType\BankStartBatch
     */
    public function addToSalesStartBatch(\StructType\SalesStartBatch $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SalesStartBatch) {
            throw new \InvalidArgumentException(sprintf('The salesStartBatch property can only contain items of \StructType\SalesStartBatch, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->salesStartBatch[] = $item;
        return $this;
    }
    /**
     * Get seqNo value
     * @return string|null
     */
    public function getSeqNo()
    {
        return $this->seqNo;
    }
    /**
     * Set seqNo value
     * @param string $seqNo
     * @return \StructType\BankStartBatch
     */
    public function setSeqNo($seqNo = null)
    {
        // validation for constraint: string
        if (!is_null($seqNo) && !is_string($seqNo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($seqNo)), __LINE__);
        }
        $this->seqNo = $seqNo;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\BankStartBatch
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
