<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BankBatch StructType
 * @subpackage Structs
 */
class BankBatch extends Batch
{
    /**
     * The firstSalesSeqNo
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $firstSalesSeqNo;
    /**
     * The lastSalesSeqNo
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $lastSalesSeqNo;
    /**
     * The depSlip
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\DepositSlip
     */
    public $depSlip;
    /**
     * The salesBatch
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SalesBatch[]
     */
    public $salesBatch;
    /**
     * The seqNo
     * @var string
     */
    public $seqNo;
    /**
     * Constructor method for BankBatch
     * @uses BankBatch::setFirstSalesSeqNo()
     * @uses BankBatch::setLastSalesSeqNo()
     * @uses BankBatch::setDepSlip()
     * @uses BankBatch::setSalesBatch()
     * @uses BankBatch::setSeqNo()
     * @param string $firstSalesSeqNo
     * @param string $lastSalesSeqNo
     * @param \StructType\DepositSlip $depSlip
     * @param \StructType\SalesBatch[] $salesBatch
     * @param string $seqNo
     */
    public function __construct($firstSalesSeqNo = null, $lastSalesSeqNo = null, \StructType\DepositSlip $depSlip = null, array $salesBatch = array(), $seqNo = null)
    {
        $this
            ->setFirstSalesSeqNo($firstSalesSeqNo)
            ->setLastSalesSeqNo($lastSalesSeqNo)
            ->setDepSlip($depSlip)
            ->setSalesBatch($salesBatch)
            ->setSeqNo($seqNo);
    }
    /**
     * Get firstSalesSeqNo value
     * @return string|null
     */
    public function getFirstSalesSeqNo()
    {
        return $this->firstSalesSeqNo;
    }
    /**
     * Set firstSalesSeqNo value
     * @param string $firstSalesSeqNo
     * @return \StructType\BankBatch
     */
    public function setFirstSalesSeqNo($firstSalesSeqNo = null)
    {
        // validation for constraint: string
        if (!is_null($firstSalesSeqNo) && !is_string($firstSalesSeqNo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($firstSalesSeqNo)), __LINE__);
        }
        $this->firstSalesSeqNo = $firstSalesSeqNo;
        return $this;
    }
    /**
     * Get lastSalesSeqNo value
     * @return string|null
     */
    public function getLastSalesSeqNo()
    {
        return $this->lastSalesSeqNo;
    }
    /**
     * Set lastSalesSeqNo value
     * @param string $lastSalesSeqNo
     * @return \StructType\BankBatch
     */
    public function setLastSalesSeqNo($lastSalesSeqNo = null)
    {
        // validation for constraint: string
        if (!is_null($lastSalesSeqNo) && !is_string($lastSalesSeqNo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($lastSalesSeqNo)), __LINE__);
        }
        $this->lastSalesSeqNo = $lastSalesSeqNo;
        return $this;
    }
    /**
     * Get depSlip value
     * @return \StructType\DepositSlip|null
     */
    public function getDepSlip()
    {
        return $this->depSlip;
    }
    /**
     * Set depSlip value
     * @param \StructType\DepositSlip $depSlip
     * @return \StructType\BankBatch
     */
    public function setDepSlip(\StructType\DepositSlip $depSlip = null)
    {
        $this->depSlip = $depSlip;
        return $this;
    }
    /**
     * Get salesBatch value
     * @return \StructType\SalesBatch[]|null
     */
    public function getSalesBatch()
    {
        return $this->salesBatch;
    }
    /**
     * Set salesBatch value
     * @throws \InvalidArgumentException
     * @param \StructType\SalesBatch[] $salesBatch
     * @return \StructType\BankBatch
     */
    public function setSalesBatch(array $salesBatch = array())
    {
        foreach ($salesBatch as $bankBatchSalesBatchItem) {
            // validation for constraint: itemType
            if (!$bankBatchSalesBatchItem instanceof \StructType\SalesBatch) {
                throw new \InvalidArgumentException(sprintf('The salesBatch property can only contain items of \StructType\SalesBatch, "%s" given', is_object($bankBatchSalesBatchItem) ? get_class($bankBatchSalesBatchItem) : gettype($bankBatchSalesBatchItem)), __LINE__);
            }
        }
        $this->salesBatch = $salesBatch;
        return $this;
    }
    /**
     * Add item to salesBatch value
     * @throws \InvalidArgumentException
     * @param \StructType\SalesBatch $item
     * @return \StructType\BankBatch
     */
    public function addToSalesBatch(\StructType\SalesBatch $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SalesBatch) {
            throw new \InvalidArgumentException(sprintf('The salesBatch property can only contain items of \StructType\SalesBatch, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->salesBatch[] = $item;
        return $this;
    }
    /**
     * Get seqNo value
     * @return string|null
     */
    public function getSeqNo()
    {
        return $this->seqNo;
    }
    /**
     * Set seqNo value
     * @param string $seqNo
     * @return \StructType\BankBatch
     */
    public function setSeqNo($seqNo = null)
    {
        // validation for constraint: string
        if (!is_null($seqNo) && !is_string($seqNo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($seqNo)), __LINE__);
        }
        $this->seqNo = $seqNo;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\BankBatch
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
