<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AccountStatus StructType
 * @subpackage Structs
 */
class AccountStatus extends AbstractStructBase
{
    /**
     * The accountIdentification
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $accountIdentification;
    /**
     * The accountName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $accountName;
    /**
     * The accountBalance
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Currency
     */
    public $accountBalance;
    /**
     * The minimumPayment
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Currency
     */
    public $minimumPayment;
    /**
     * Constructor method for AccountStatus
     * @uses AccountStatus::setAccountIdentification()
     * @uses AccountStatus::setAccountName()
     * @uses AccountStatus::setAccountBalance()
     * @uses AccountStatus::setMinimumPayment()
     * @param string $accountIdentification
     * @param string $accountName
     * @param \StructType\Currency $accountBalance
     * @param \StructType\Currency $minimumPayment
     */
    public function __construct($accountIdentification = null, $accountName = null, \StructType\Currency $accountBalance = null, \StructType\Currency $minimumPayment = null)
    {
        $this
            ->setAccountIdentification($accountIdentification)
            ->setAccountName($accountName)
            ->setAccountBalance($accountBalance)
            ->setMinimumPayment($minimumPayment);
    }
    /**
     * Get accountIdentification value
     * @return string|null
     */
    public function getAccountIdentification()
    {
        return $this->accountIdentification;
    }
    /**
     * Set accountIdentification value
     * @param string $accountIdentification
     * @return \StructType\AccountStatus
     */
    public function setAccountIdentification($accountIdentification = null)
    {
        // validation for constraint: string
        if (!is_null($accountIdentification) && !is_string($accountIdentification)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($accountIdentification)), __LINE__);
        }
        $this->accountIdentification = $accountIdentification;
        return $this;
    }
    /**
     * Get accountName value
     * @return string|null
     */
    public function getAccountName()
    {
        return $this->accountName;
    }
    /**
     * Set accountName value
     * @param string $accountName
     * @return \StructType\AccountStatus
     */
    public function setAccountName($accountName = null)
    {
        // validation for constraint: string
        if (!is_null($accountName) && !is_string($accountName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($accountName)), __LINE__);
        }
        $this->accountName = $accountName;
        return $this;
    }
    /**
     * Get accountBalance value
     * @return \StructType\Currency|null
     */
    public function getAccountBalance()
    {
        return $this->accountBalance;
    }
    /**
     * Set accountBalance value
     * @param \StructType\Currency $accountBalance
     * @return \StructType\AccountStatus
     */
    public function setAccountBalance(\StructType\Currency $accountBalance = null)
    {
        $this->accountBalance = $accountBalance;
        return $this;
    }
    /**
     * Get minimumPayment value
     * @return \StructType\Currency|null
     */
    public function getMinimumPayment()
    {
        return $this->minimumPayment;
    }
    /**
     * Set minimumPayment value
     * @param \StructType\Currency $minimumPayment
     * @return \StructType\AccountStatus
     */
    public function setMinimumPayment(\StructType\Currency $minimumPayment = null)
    {
        $this->minimumPayment = $minimumPayment;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\AccountStatus
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
