<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Trial ServiceType
 * @subpackage Services
 */
class Trial extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named TrialCreditVendRequest
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\TrialCreditVendRequest $parameters
     * @return \StructType\TrialCreditVendRequestResponse|bool
     */
    public function TrialCreditVendRequest(\StructType\TrialCreditVendRequest $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->TrialCreditVendRequest($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\TrialCreditVendRequestResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
