<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Credit ServiceType
 * @subpackage Services
 */
class Credit extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named CreditVendRequest
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\CreditVendRequest $parameters
     * @return \StructType\CreditVendRequestResponse|bool
     */
    public function CreditVendRequest(\StructType\CreditVendRequest $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->CreditVendRequest($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\CreditVendRequestResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
