<?php

namespace EnumType;

/**
 * This class stands for MeterSpecificEng EnumType
 * @subpackage Enumerations
 */
class MeterSpecificEng
{
    /**
     * Constant for value 'SetPwrLmt'
     * @return string 'SetPwrLmt'
     */
    const VALUE_SET_PWR_LMT = 'SetPwrLmt';
    /**
     * Constant for value 'SetPhUnbalance'
     * @return string 'SetPhUnbalance'
     */
    const VALUE_SET_PH_UNBALANCE = 'SetPhUnbalance';
    /**
     * Constant for value 'AddDefaultCred'
     * @return string 'AddDefaultCred'
     */
    const VALUE_ADD_DEFAULT_CRED = 'AddDefaultCred';
    /**
     * Constant for value 'ClearCred'
     * @return string 'ClearCred'
     */
    const VALUE_CLEAR_CRED = 'ClearCred';
    /**
     * Constant for value 'ClearTamper'
     * @return string 'ClearTamper'
     */
    const VALUE_CLEAR_TAMPER = 'ClearTamper';
    /**
     * Constant for value 'EngKCT'
     * @return string 'EngKCT'
     */
    const VALUE_ENG_KCT = 'EngKCT';
    /**
     * Constant for value 'SetWaterFact'
     * @return string 'SetWaterFact'
     */
    const VALUE_SET_WATER_FACT = 'SetWaterFact';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_SET_PWR_LMT
     * @uses self::VALUE_SET_PH_UNBALANCE
     * @uses self::VALUE_ADD_DEFAULT_CRED
     * @uses self::VALUE_CLEAR_CRED
     * @uses self::VALUE_CLEAR_TAMPER
     * @uses self::VALUE_ENG_KCT
     * @uses self::VALUE_SET_WATER_FACT
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_SET_PWR_LMT,
            self::VALUE_SET_PH_UNBALANCE,
            self::VALUE_ADD_DEFAULT_CRED,
            self::VALUE_CLEAR_CRED,
            self::VALUE_CLEAR_TAMPER,
            self::VALUE_ENG_KCT,
            self::VALUE_SET_WATER_FACT,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
