<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfStep ArrayType
 * @subpackage Arrays
 */
class ArrayOfStep extends AbstractStructArrayBase
{
    /**
     * The Step
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\Step[]
     */
    public $Step;
    /**
     * Constructor method for ArrayOfStep
     * @uses ArrayOfStep::setStep()
     * @param \StructType\Step[] $step
     */
    public function __construct(array $step = array())
    {
        $this
            ->setStep($step);
    }
    /**
     * Get Step value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\Step[]|null
     */
    public function getStep()
    {
        return isset($this->Step) ? $this->Step : null;
    }
    /**
     * Set Step value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\Step[] $step
     * @return \ArrayType\ArrayOfStep
     */
    public function setStep(array $step = array())
    {
        foreach ($step as $arrayOfStepStepItem) {
            // validation for constraint: itemType
            if (!$arrayOfStepStepItem instanceof \StructType\Step) {
                throw new \InvalidArgumentException(sprintf('The Step property can only contain items of \StructType\Step, "%s" given', is_object($arrayOfStepStepItem) ? get_class($arrayOfStepStepItem) : gettype($arrayOfStepStepItem)), __LINE__);
            }
        }
        if (is_null($step) || (is_array($step) && empty($step))) {
            unset($this->Step);
        } else {
            $this->Step = $step;
        }
        return $this;
    }
    /**
     * Add item to Step value
     * @throws \InvalidArgumentException
     * @param \StructType\Step $item
     * @return \ArrayType\ArrayOfStep
     */
    public function addToStep(\StructType\Step $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Step) {
            throw new \InvalidArgumentException(sprintf('The Step property can only contain items of \StructType\Step, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->Step[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\Step|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\Step|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\Step|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\Step|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\Step|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string Step
     */
    public function getAttributeName()
    {
        return 'Step';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfStep
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
