<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Units StructType
 * @subpackage Structs
 */
class Units extends AbstractStructBase
{
    /**
     * The value
     * Meta informations extracted from the WSDL
     * - use: required
     * @var float
     */
    public $value;
    /**
     * The siUnit
     * @var string
     */
    public $siUnit;
    /**
     * Constructor method for Units
     * @uses Units::setValue()
     * @uses Units::setSiUnit()
     * @param float $value
     * @param string $siUnit
     */
    public function __construct($value = null, $siUnit = null)
    {
        $this
            ->setValue($value)
            ->setSiUnit($siUnit);
    }
    /**
     * Get value value
     * @return float
     */
    public function getValue()
    {
        return $this->value;
    }
    /**
     * Set value value
     * @param float $value
     * @return \StructType\Units
     */
    public function setValue($value = null)
    {
        $this->value = $value;
        return $this;
    }
    /**
     * Get siUnit value
     * @return string|null
     */
    public function getSiUnit()
    {
        return $this->siUnit;
    }
    /**
     * Set siUnit value
     * @param string $siUnit
     * @return \StructType\Units
     */
    public function setSiUnit($siUnit = null)
    {
        // validation for constraint: string
        if (!is_null($siUnit) && !is_string($siUnit)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($siUnit)), __LINE__);
        }
        $this->siUnit = $siUnit;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Units
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
