<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Transactions StructType
 * @subpackage Structs
 */
class Transactions extends AbstractStructBase
{
    /**
     * The tx
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Tx[]
     */
    public $tx;
    /**
     * The lessRound
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Currency
     */
    public $lessRound;
    /**
     * The tenderAmt
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Currency
     */
    public $tenderAmt;
    /**
     * The change
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Currency
     */
    public $change;
    /**
     * The units
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Currency
     */
    public $units;
    /**
     * Constructor method for Transactions
     * @uses Transactions::setTx()
     * @uses Transactions::setLessRound()
     * @uses Transactions::setTenderAmt()
     * @uses Transactions::setChange()
     * @uses Transactions::setUnits()
     * @param \StructType\Tx[] $tx
     * @param \StructType\Currency $lessRound
     * @param \StructType\Currency $tenderAmt
     * @param \StructType\Currency $change
     * @param \StructType\Currency $units
     */
    public function __construct(array $tx = array(), \StructType\Currency $lessRound = null, \StructType\Currency $tenderAmt = null, \StructType\Currency $change = null, \StructType\Currency $units = null)
    {
        $this
            ->setTx($tx)
            ->setLessRound($lessRound)
            ->setTenderAmt($tenderAmt)
            ->setChange($change)
            ->setUnits($units);
    }
    /**
     * Get tx value
     * @return \StructType\Tx[]|null
     */
    public function getTx()
    {
        return $this->tx;
    }
    /**
     * Set tx value
     * @throws \InvalidArgumentException
     * @param \StructType\Tx[] $tx
     * @return \StructType\Transactions
     */
    public function setTx(array $tx = array())
    {
        foreach ($tx as $transactionsTxItem) {
            // validation for constraint: itemType
            if (!$transactionsTxItem instanceof \StructType\Tx) {
                throw new \InvalidArgumentException(sprintf('The tx property can only contain items of \StructType\Tx, "%s" given', is_object($transactionsTxItem) ? get_class($transactionsTxItem) : gettype($transactionsTxItem)), __LINE__);
            }
        }
        $this->tx = $tx;
        return $this;
    }
    /**
     * Add item to tx value
     * @throws \InvalidArgumentException
     * @param \StructType\Tx $item
     * @return \StructType\Transactions
     */
    public function addToTx(\StructType\Tx $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Tx) {
            throw new \InvalidArgumentException(sprintf('The tx property can only contain items of \StructType\Tx, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->tx[] = $item;
        return $this;
    }
    /**
     * Get lessRound value
     * @return \StructType\Currency|null
     */
    public function getLessRound()
    {
        return $this->lessRound;
    }
    /**
     * Set lessRound value
     * @param \StructType\Currency $lessRound
     * @return \StructType\Transactions
     */
    public function setLessRound(\StructType\Currency $lessRound = null)
    {
        $this->lessRound = $lessRound;
        return $this;
    }
    /**
     * Get tenderAmt value
     * @return \StructType\Currency|null
     */
    public function getTenderAmt()
    {
        return $this->tenderAmt;
    }
    /**
     * Set tenderAmt value
     * @param \StructType\Currency $tenderAmt
     * @return \StructType\Transactions
     */
    public function setTenderAmt(\StructType\Currency $tenderAmt = null)
    {
        $this->tenderAmt = $tenderAmt;
        return $this;
    }
    /**
     * Get change value
     * @return \StructType\Currency|null
     */
    public function getChange()
    {
        return $this->change;
    }
    /**
     * Set change value
     * @param \StructType\Currency $change
     * @return \StructType\Transactions
     */
    public function setChange(\StructType\Currency $change = null)
    {
        $this->change = $change;
        return $this;
    }
    /**
     * Get units value
     * @return \StructType\Currency|null
     */
    public function getUnits()
    {
        return $this->units;
    }
    /**
     * Set units value
     * @param \StructType\Currency $units
     * @return \StructType\Transactions
     */
    public function setUnits(\StructType\Currency $units = null)
    {
        $this->units = $units;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Transactions
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
