<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TokenSubClassType StructType
 * @subpackage Structs
 */
class TokenSubClassType extends AbstractStructBase
{
    /**
     * The credit
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $credit;
    /**
     * The meterManagement
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $meterManagement;
    /**
     * The nonMeterManagement
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $nonMeterManagement;
    /**
     * Constructor method for TokenSubClassType
     * @uses TokenSubClassType::setCredit()
     * @uses TokenSubClassType::setMeterManagement()
     * @uses TokenSubClassType::setNonMeterManagement()
     * @param string $credit
     * @param string $meterManagement
     * @param string $nonMeterManagement
     */
    public function __construct($credit = null, $meterManagement = null, $nonMeterManagement = null)
    {
        $this
            ->setCredit($credit)
            ->setMeterManagement($meterManagement)
            ->setNonMeterManagement($nonMeterManagement);
    }
    /**
     * Get credit value
     * @return string
     */
    public function getCredit()
    {
        return $this->credit;
    }
    /**
     * Set credit value
     * @uses \EnumType\CreditTokenSubClassType::valueIsValid()
     * @uses \EnumType\CreditTokenSubClassType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $credit
     * @return \StructType\TokenSubClassType
     */
    public function setCredit($credit = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\CreditTokenSubClassType::valueIsValid($credit)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $credit, implode(', ', \EnumType\CreditTokenSubClassType::getValidValues())), __LINE__);
        }
        $this->credit = $credit;
        return $this;
    }
    /**
     * Get meterManagement value
     * @return string
     */
    public function getMeterManagement()
    {
        return $this->meterManagement;
    }
    /**
     * Set meterManagement value
     * @uses \EnumType\MeterSpecificEng::valueIsValid()
     * @uses \EnumType\MeterSpecificEng::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $meterManagement
     * @return \StructType\TokenSubClassType
     */
    public function setMeterManagement($meterManagement = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\MeterSpecificEng::valueIsValid($meterManagement)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $meterManagement, implode(', ', \EnumType\MeterSpecificEng::getValidValues())), __LINE__);
        }
        $this->meterManagement = $meterManagement;
        return $this;
    }
    /**
     * Get nonMeterManagement value
     * @return string
     */
    public function getNonMeterManagement()
    {
        return $this->nonMeterManagement;
    }
    /**
     * Set nonMeterManagement value
     * @uses \EnumType\NonMeterSpecificEng::valueIsValid()
     * @uses \EnumType\NonMeterSpecificEng::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $nonMeterManagement
     * @return \StructType\TokenSubClassType
     */
    public function setNonMeterManagement($nonMeterManagement = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\NonMeterSpecificEng::valueIsValid($nonMeterManagement)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $nonMeterManagement, implode(', ', \EnumType\NonMeterSpecificEng::getValidValues())), __LINE__);
        }
        $this->nonMeterManagement = $nonMeterManagement;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\TokenSubClassType
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
