<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Tariff StructType
 * @subpackage Structs
 */
class Tariff extends AbstractStructBase
{
    /**
     * The name
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $name;
    /**
     * The desc
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $desc;
    /**
     * The TariffSetID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $TariffSetID;
    /**
     * The SGC
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $SGC;
    /**
     * Constructor method for Tariff
     * @uses Tariff::setName()
     * @uses Tariff::setDesc()
     * @uses Tariff::setTariffSetID()
     * @uses Tariff::setSGC()
     * @param string $name
     * @param string $desc
     * @param string $tariffSetID
     * @param string $sGC
     */
    public function __construct($name = null, $desc = null, $tariffSetID = null, $sGC = null)
    {
        $this
            ->setName($name)
            ->setDesc($desc)
            ->setTariffSetID($tariffSetID)
            ->setSGC($sGC);
    }
    /**
     * Get name value
     * @return string|null
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return \StructType\Tariff
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($name)), __LINE__);
        }
        $this->name = $name;
        return $this;
    }
    /**
     * Get desc value
     * @return string|null
     */
    public function getDesc()
    {
        return $this->desc;
    }
    /**
     * Set desc value
     * @param string $desc
     * @return \StructType\Tariff
     */
    public function setDesc($desc = null)
    {
        // validation for constraint: string
        if (!is_null($desc) && !is_string($desc)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($desc)), __LINE__);
        }
        $this->desc = $desc;
        return $this;
    }
    /**
     * Get TariffSetID value
     * @return string|null
     */
    public function getTariffSetID()
    {
        return $this->TariffSetID;
    }
    /**
     * Set TariffSetID value
     * @param string $tariffSetID
     * @return \StructType\Tariff
     */
    public function setTariffSetID($tariffSetID = null)
    {
        // validation for constraint: string
        if (!is_null($tariffSetID) && !is_string($tariffSetID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($tariffSetID)), __LINE__);
        }
        $this->TariffSetID = $tariffSetID;
        return $this;
    }
    /**
     * Get SGC value
     * @return string|null
     */
    public function getSGC()
    {
        return $this->SGC;
    }
    /**
     * Set SGC value
     * @param string $sGC
     * @return \StructType\Tariff
     */
    public function setSGC($sGC = null)
    {
        // validation for constraint: string
        if (!is_null($sGC) && !is_string($sGC)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($sGC)), __LINE__);
        }
        $this->SGC = $sGC;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Tariff
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
