<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SalesBatch StructType
 * @subpackage Structs
 */
class SalesBatch extends Batch
{
    /**
     * The firstTxSeqNo
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $firstTxSeqNo;
    /**
     * The lastTxSeqNo
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $lastTxSeqNo;
    /**
     * The shiftBatch
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\ShiftBatch[]
     */
    public $shiftBatch;
    /**
     * The seqNo
     * @var string
     */
    public $seqNo;
    /**
     * Constructor method for SalesBatch
     * @uses SalesBatch::setFirstTxSeqNo()
     * @uses SalesBatch::setLastTxSeqNo()
     * @uses SalesBatch::setShiftBatch()
     * @uses SalesBatch::setSeqNo()
     * @param string $firstTxSeqNo
     * @param string $lastTxSeqNo
     * @param \StructType\ShiftBatch[] $shiftBatch
     * @param string $seqNo
     */
    public function __construct($firstTxSeqNo = null, $lastTxSeqNo = null, array $shiftBatch = array(), $seqNo = null)
    {
        $this
            ->setFirstTxSeqNo($firstTxSeqNo)
            ->setLastTxSeqNo($lastTxSeqNo)
            ->setShiftBatch($shiftBatch)
            ->setSeqNo($seqNo);
    }
    /**
     * Get firstTxSeqNo value
     * @return string|null
     */
    public function getFirstTxSeqNo()
    {
        return $this->firstTxSeqNo;
    }
    /**
     * Set firstTxSeqNo value
     * @param string $firstTxSeqNo
     * @return \StructType\SalesBatch
     */
    public function setFirstTxSeqNo($firstTxSeqNo = null)
    {
        // validation for constraint: string
        if (!is_null($firstTxSeqNo) && !is_string($firstTxSeqNo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($firstTxSeqNo)), __LINE__);
        }
        $this->firstTxSeqNo = $firstTxSeqNo;
        return $this;
    }
    /**
     * Get lastTxSeqNo value
     * @return string|null
     */
    public function getLastTxSeqNo()
    {
        return $this->lastTxSeqNo;
    }
    /**
     * Set lastTxSeqNo value
     * @param string $lastTxSeqNo
     * @return \StructType\SalesBatch
     */
    public function setLastTxSeqNo($lastTxSeqNo = null)
    {
        // validation for constraint: string
        if (!is_null($lastTxSeqNo) && !is_string($lastTxSeqNo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($lastTxSeqNo)), __LINE__);
        }
        $this->lastTxSeqNo = $lastTxSeqNo;
        return $this;
    }
    /**
     * Get shiftBatch value
     * @return \StructType\ShiftBatch[]|null
     */
    public function getShiftBatch()
    {
        return $this->shiftBatch;
    }
    /**
     * Set shiftBatch value
     * @throws \InvalidArgumentException
     * @param \StructType\ShiftBatch[] $shiftBatch
     * @return \StructType\SalesBatch
     */
    public function setShiftBatch(array $shiftBatch = array())
    {
        foreach ($shiftBatch as $salesBatchShiftBatchItem) {
            // validation for constraint: itemType
            if (!$salesBatchShiftBatchItem instanceof \StructType\ShiftBatch) {
                throw new \InvalidArgumentException(sprintf('The shiftBatch property can only contain items of \StructType\ShiftBatch, "%s" given', is_object($salesBatchShiftBatchItem) ? get_class($salesBatchShiftBatchItem) : gettype($salesBatchShiftBatchItem)), __LINE__);
            }
        }
        $this->shiftBatch = $shiftBatch;
        return $this;
    }
    /**
     * Add item to shiftBatch value
     * @throws \InvalidArgumentException
     * @param \StructType\ShiftBatch $item
     * @return \StructType\SalesBatch
     */
    public function addToShiftBatch(\StructType\ShiftBatch $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ShiftBatch) {
            throw new \InvalidArgumentException(sprintf('The shiftBatch property can only contain items of \StructType\ShiftBatch, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->shiftBatch[] = $item;
        return $this;
    }
    /**
     * Get seqNo value
     * @return string|null
     */
    public function getSeqNo()
    {
        return $this->seqNo;
    }
    /**
     * Set seqNo value
     * @param string $seqNo
     * @return \StructType\SalesBatch
     */
    public function setSeqNo($seqNo = null)
    {
        // validation for constraint: string
        if (!is_null($seqNo) && !is_string($seqNo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($seqNo)), __LINE__);
        }
        $this->seqNo = $seqNo;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\SalesBatch
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
