<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for STS1TokenInfo StructType
 * @subpackage Structs
 */
class STS1TokenInfo extends TokenInfo
{
    /**
     * The tokenID
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $tokenID;
    /**
     * The transferAmt
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $transferAmt;
    /**
     * The tokenClass
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\TokenSubClassType
     */
    public $tokenClass;
    /**
     * Constructor method for STS1TokenInfo
     * @uses STS1TokenInfo::setTokenID()
     * @uses STS1TokenInfo::setTransferAmt()
     * @uses STS1TokenInfo::setTokenClass()
     * @param float $tokenID
     * @param float $transferAmt
     * @param \StructType\TokenSubClassType $tokenClass
     */
    public function __construct($tokenID = null, $transferAmt = null, \StructType\TokenSubClassType $tokenClass = null)
    {
        $this
            ->setTokenID($tokenID)
            ->setTransferAmt($transferAmt)
            ->setTokenClass($tokenClass);
    }
    /**
     * Get tokenID value
     * @return float
     */
    public function getTokenID()
    {
        return $this->tokenID;
    }
    /**
     * Set tokenID value
     * @param float $tokenID
     * @return \StructType\STS1TokenInfo
     */
    public function setTokenID($tokenID = null)
    {
        $this->tokenID = $tokenID;
        return $this;
    }
    /**
     * Get transferAmt value
     * @return float
     */
    public function getTransferAmt()
    {
        return $this->transferAmt;
    }
    /**
     * Set transferAmt value
     * @param float $transferAmt
     * @return \StructType\STS1TokenInfo
     */
    public function setTransferAmt($transferAmt = null)
    {
        $this->transferAmt = $transferAmt;
        return $this;
    }
    /**
     * Get tokenClass value
     * @return \StructType\TokenSubClassType|null
     */
    public function getTokenClass()
    {
        return $this->tokenClass;
    }
    /**
     * Set tokenClass value
     * @param \StructType\TokenSubClassType $tokenClass
     * @return \StructType\STS1TokenInfo
     */
    public function setTokenClass(\StructType\TokenSubClassType $tokenClass = null)
    {
        $this->tokenClass = $tokenClass;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\STS1TokenInfo
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
