<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Receipt StructType
 * @subpackage Structs
 */
abstract class Receipt extends AbstractStructBase
{
    /**
     * The transactions
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Transactions
     */
    public $transactions;
    /**
     * The receiptNo
     * @var string
     */
    public $receiptNo;
    /**
     * Constructor method for Receipt
     * @uses Receipt::setTransactions()
     * @uses Receipt::setReceiptNo()
     * @param \StructType\Transactions $transactions
     * @param string $receiptNo
     */
    public function __construct(\StructType\Transactions $transactions = null, $receiptNo = null)
    {
        $this
            ->setTransactions($transactions)
            ->setReceiptNo($receiptNo);
    }
    /**
     * Get transactions value
     * @return \StructType\Transactions|null
     */
    public function getTransactions()
    {
        return $this->transactions;
    }
    /**
     * Set transactions value
     * @param \StructType\Transactions $transactions
     * @return \StructType\Receipt
     */
    public function setTransactions(\StructType\Transactions $transactions = null)
    {
        $this->transactions = $transactions;
        return $this;
    }
    /**
     * Get receiptNo value
     * @return string|null
     */
    public function getReceiptNo()
    {
        return $this->receiptNo;
    }
    /**
     * Set receiptNo value
     * @param string $receiptNo
     * @return \StructType\Receipt
     */
    public function setReceiptNo($receiptNo = null)
    {
        // validation for constraint: string
        if (!is_null($receiptNo) && !is_string($receiptNo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($receiptNo)), __LINE__);
        }
        $this->receiptNo = $receiptNo;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Receipt
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
