<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for NonMeterSpecificEngReq StructType
 * @subpackage Structs
 */
abstract class NonMeterSpecificEngReq extends BaseReq
{
    /**
     * The vendingServerId
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $vendingServerId;
    /**
     * The meterType
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\MeterType
     */
    public $meterType;
    /**
     * The manufacturerCode
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $manufacturerCode;
    /**
     * Constructor method for NonMeterSpecificEngReq
     * @uses NonMeterSpecificEngReq::setVendingServerId()
     * @uses NonMeterSpecificEngReq::setMeterType()
     * @uses NonMeterSpecificEngReq::setManufacturerCode()
     * @param int $vendingServerId
     * @param \StructType\MeterType $meterType
     * @param string $manufacturerCode
     */
    public function __construct($vendingServerId = null, \StructType\MeterType $meterType = null, $manufacturerCode = null)
    {
        $this
            ->setVendingServerId($vendingServerId)
            ->setMeterType($meterType)
            ->setManufacturerCode($manufacturerCode);
    }
    /**
     * Get vendingServerId value
     * @return int
     */
    public function getVendingServerId()
    {
        return $this->vendingServerId;
    }
    /**
     * Set vendingServerId value
     * @param int $vendingServerId
     * @return \StructType\NonMeterSpecificEngReq
     */
    public function setVendingServerId($vendingServerId = null)
    {
        // validation for constraint: int
        if (!is_null($vendingServerId) && !is_numeric($vendingServerId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($vendingServerId)), __LINE__);
        }
        $this->vendingServerId = $vendingServerId;
        return $this;
    }
    /**
     * Get meterType value
     * @return \StructType\MeterType|null
     */
    public function getMeterType()
    {
        return $this->meterType;
    }
    /**
     * Set meterType value
     * @param \StructType\MeterType $meterType
     * @return \StructType\NonMeterSpecificEngReq
     */
    public function setMeterType(\StructType\MeterType $meterType = null)
    {
        $this->meterType = $meterType;
        return $this;
    }
    /**
     * Get manufacturerCode value
     * @return string|null
     */
    public function getManufacturerCode()
    {
        return $this->manufacturerCode;
    }
    /**
     * Set manufacturerCode value
     * @param string $manufacturerCode
     * @return \StructType\NonMeterSpecificEngReq
     */
    public function setManufacturerCode($manufacturerCode = null)
    {
        // validation for constraint: string
        if (!is_null($manufacturerCode) && !is_string($manufacturerCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($manufacturerCode)), __LINE__);
        }
        $this->manufacturerCode = $manufacturerCode;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\NonMeterSpecificEngReq
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
