<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for MeterDetail StructType
 * @subpackage Structs
 */
class MeterDetail extends MeterConfig
{
    /**
     * The meterType
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\MeterType
     */
    public $meterType;
    /**
     * The krn
     * @var string
     */
    public $krn;
    /**
     * The ti
     * @var string
     */
    public $ti;
    /**
     * The msno
     * @var string
     */
    public $msno;
    /**
     * The sgc
     * @var string
     */
    public $sgc;
    /**
     * Constructor method for MeterDetail
     * @uses MeterDetail::setMeterType()
     * @uses MeterDetail::setKrn()
     * @uses MeterDetail::setTi()
     * @uses MeterDetail::setMsno()
     * @uses MeterDetail::setSgc()
     * @param \StructType\MeterType $meterType
     * @param string $krn
     * @param string $ti
     * @param string $msno
     * @param string $sgc
     */
    public function __construct(\StructType\MeterType $meterType = null, $krn = null, $ti = null, $msno = null, $sgc = null)
    {
        $this
            ->setMeterType($meterType)
            ->setKrn($krn)
            ->setTi($ti)
            ->setMsno($msno)
            ->setSgc($sgc);
    }
    /**
     * Get meterType value
     * @return \StructType\MeterType|null
     */
    public function getMeterType()
    {
        return $this->meterType;
    }
    /**
     * Set meterType value
     * @param \StructType\MeterType $meterType
     * @return \StructType\MeterDetail
     */
    public function setMeterType(\StructType\MeterType $meterType = null)
    {
        $this->meterType = $meterType;
        return $this;
    }
    /**
     * Get krn value
     * @return string|null
     */
    public function getKrn()
    {
        return $this->krn;
    }
    /**
     * Set krn value
     * @param string $krn
     * @return \StructType\MeterDetail
     */
    public function setKrn($krn = null)
    {
        // validation for constraint: string
        if (!is_null($krn) && !is_string($krn)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($krn)), __LINE__);
        }
        $this->krn = $krn;
        return $this;
    }
    /**
     * Get ti value
     * @return string|null
     */
    public function getTi()
    {
        return $this->ti;
    }
    /**
     * Set ti value
     * @param string $ti
     * @return \StructType\MeterDetail
     */
    public function setTi($ti = null)
    {
        // validation for constraint: string
        if (!is_null($ti) && !is_string($ti)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($ti)), __LINE__);
        }
        $this->ti = $ti;
        return $this;
    }
    /**
     * Get msno value
     * @return string|null
     */
    public function getMsno()
    {
        return $this->msno;
    }
    /**
     * Set msno value
     * @param string $msno
     * @return \StructType\MeterDetail
     */
    public function setMsno($msno = null)
    {
        // validation for constraint: string
        if (!is_null($msno) && !is_string($msno)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($msno)), __LINE__);
        }
        $this->msno = $msno;
        return $this;
    }
    /**
     * Get sgc value
     * @return string|null
     */
    public function getSgc()
    {
        return $this->sgc;
    }
    /**
     * Set sgc value
     * @param string $sgc
     * @return \StructType\MeterDetail
     */
    public function setSgc($sgc = null)
    {
        // validation for constraint: string
        if (!is_null($sgc) && !is_string($sgc)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($sgc)), __LINE__);
        }
        $this->sgc = $sgc;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\MeterDetail
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
