<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for MakeMerchantDepositReq StructType
 * @subpackage Structs
 */
class MakeMerchantDepositReq extends BaseReq
{
    /**
     * The AmountDeposited
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var float
     */
    public $AmountDeposited;
    /**
     * The AccountHolderName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $AccountHolderName;
    /**
     * The AccountNo
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $AccountNo;
    /**
     * The BankName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $BankName;
    /**
     * The DateDeposited
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DateDeposited;
    /**
     * The DepositReferenceNumber
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DepositReferenceNumber;
    /**
     * The Notes
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Notes;
    /**
     * The BankBranchCode
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $BankBranchCode;
    /**
     * Constructor method for MakeMerchantDepositReq
     * @uses MakeMerchantDepositReq::setAmountDeposited()
     * @uses MakeMerchantDepositReq::setAccountHolderName()
     * @uses MakeMerchantDepositReq::setAccountNo()
     * @uses MakeMerchantDepositReq::setBankName()
     * @uses MakeMerchantDepositReq::setDateDeposited()
     * @uses MakeMerchantDepositReq::setDepositReferenceNumber()
     * @uses MakeMerchantDepositReq::setNotes()
     * @uses MakeMerchantDepositReq::setBankBranchCode()
     * @param float $amountDeposited
     * @param string $accountHolderName
     * @param string $accountNo
     * @param string $bankName
     * @param string $dateDeposited
     * @param string $depositReferenceNumber
     * @param string $notes
     * @param string $bankBranchCode
     */
    public function __construct($amountDeposited = null, $accountHolderName = null, $accountNo = null, $bankName = null, $dateDeposited = null, $depositReferenceNumber = null, $notes = null, $bankBranchCode = null)
    {
        $this
            ->setAmountDeposited($amountDeposited)
            ->setAccountHolderName($accountHolderName)
            ->setAccountNo($accountNo)
            ->setBankName($bankName)
            ->setDateDeposited($dateDeposited)
            ->setDepositReferenceNumber($depositReferenceNumber)
            ->setNotes($notes)
            ->setBankBranchCode($bankBranchCode);
    }
    /**
     * Get AmountDeposited value
     * @return float
     */
    public function getAmountDeposited()
    {
        return $this->AmountDeposited;
    }
    /**
     * Set AmountDeposited value
     * @param float $amountDeposited
     * @return \StructType\MakeMerchantDepositReq
     */
    public function setAmountDeposited($amountDeposited = null)
    {
        $this->AmountDeposited = $amountDeposited;
        return $this;
    }
    /**
     * Get AccountHolderName value
     * @return string|null
     */
    public function getAccountHolderName()
    {
        return $this->AccountHolderName;
    }
    /**
     * Set AccountHolderName value
     * @param string $accountHolderName
     * @return \StructType\MakeMerchantDepositReq
     */
    public function setAccountHolderName($accountHolderName = null)
    {
        // validation for constraint: string
        if (!is_null($accountHolderName) && !is_string($accountHolderName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($accountHolderName)), __LINE__);
        }
        $this->AccountHolderName = $accountHolderName;
        return $this;
    }
    /**
     * Get AccountNo value
     * @return string|null
     */
    public function getAccountNo()
    {
        return $this->AccountNo;
    }
    /**
     * Set AccountNo value
     * @param string $accountNo
     * @return \StructType\MakeMerchantDepositReq
     */
    public function setAccountNo($accountNo = null)
    {
        // validation for constraint: string
        if (!is_null($accountNo) && !is_string($accountNo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($accountNo)), __LINE__);
        }
        $this->AccountNo = $accountNo;
        return $this;
    }
    /**
     * Get BankName value
     * @return string|null
     */
    public function getBankName()
    {
        return $this->BankName;
    }
    /**
     * Set BankName value
     * @param string $bankName
     * @return \StructType\MakeMerchantDepositReq
     */
    public function setBankName($bankName = null)
    {
        // validation for constraint: string
        if (!is_null($bankName) && !is_string($bankName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($bankName)), __LINE__);
        }
        $this->BankName = $bankName;
        return $this;
    }
    /**
     * Get DateDeposited value
     * @return string|null
     */
    public function getDateDeposited()
    {
        return $this->DateDeposited;
    }
    /**
     * Set DateDeposited value
     * @param string $dateDeposited
     * @return \StructType\MakeMerchantDepositReq
     */
    public function setDateDeposited($dateDeposited = null)
    {
        // validation for constraint: string
        if (!is_null($dateDeposited) && !is_string($dateDeposited)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($dateDeposited)), __LINE__);
        }
        $this->DateDeposited = $dateDeposited;
        return $this;
    }
    /**
     * Get DepositReferenceNumber value
     * @return string|null
     */
    public function getDepositReferenceNumber()
    {
        return $this->DepositReferenceNumber;
    }
    /**
     * Set DepositReferenceNumber value
     * @param string $depositReferenceNumber
     * @return \StructType\MakeMerchantDepositReq
     */
    public function setDepositReferenceNumber($depositReferenceNumber = null)
    {
        // validation for constraint: string
        if (!is_null($depositReferenceNumber) && !is_string($depositReferenceNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($depositReferenceNumber)), __LINE__);
        }
        $this->DepositReferenceNumber = $depositReferenceNumber;
        return $this;
    }
    /**
     * Get Notes value
     * @return string|null
     */
    public function getNotes()
    {
        return $this->Notes;
    }
    /**
     * Set Notes value
     * @param string $notes
     * @return \StructType\MakeMerchantDepositReq
     */
    public function setNotes($notes = null)
    {
        // validation for constraint: string
        if (!is_null($notes) && !is_string($notes)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($notes)), __LINE__);
        }
        $this->Notes = $notes;
        return $this;
    }
    /**
     * Get BankBranchCode value
     * @return string|null
     */
    public function getBankBranchCode()
    {
        return $this->BankBranchCode;
    }
    /**
     * Set BankBranchCode value
     * @param string $bankBranchCode
     * @return \StructType\MakeMerchantDepositReq
     */
    public function setBankBranchCode($bankBranchCode = null)
    {
        // validation for constraint: string
        if (!is_null($bankBranchCode) && !is_string($bankBranchCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($bankBranchCode)), __LINE__);
        }
        $this->BankBranchCode = $bankBranchCode;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\MakeMerchantDepositReq
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
