<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CustAccountNo StructType
 * @subpackage Structs
 */
class CustAccountNo extends CustIdentifier
{
    /**
     * The organisation
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $organisation;
    /**
     * The accNo
     * @var string
     */
    public $accNo;
    /**
     * Constructor method for CustAccountNo
     * @uses CustAccountNo::setOrganisation()
     * @uses CustAccountNo::setAccNo()
     * @param string $organisation
     * @param string $accNo
     */
    public function __construct($organisation = null, $accNo = null)
    {
        $this
            ->setOrganisation($organisation)
            ->setAccNo($accNo);
    }
    /**
     * Get organisation value
     * @return string|null
     */
    public function getOrganisation()
    {
        return $this->organisation;
    }
    /**
     * Set organisation value
     * @param string $organisation
     * @return \StructType\CustAccountNo
     */
    public function setOrganisation($organisation = null)
    {
        // validation for constraint: string
        if (!is_null($organisation) && !is_string($organisation)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($organisation)), __LINE__);
        }
        $this->organisation = $organisation;
        return $this;
    }
    /**
     * Get accNo value
     * @return string|null
     */
    public function getAccNo()
    {
        return $this->accNo;
    }
    /**
     * Set accNo value
     * @param string $accNo
     * @return \StructType\CustAccountNo
     */
    public function setAccNo($accNo = null)
    {
        // validation for constraint: string
        if (!is_null($accNo) && !is_string($accNo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($accNo)), __LINE__);
        }
        $this->accNo = $accNo;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\CustAccountNo
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
