<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CreditVendTx StructType
 * @subpackage Structs
 */
class CreditVendTx extends Tx
{
    /**
     * The creditTokenIssue
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\CreditTokenIssue
     */
    public $creditTokenIssue;
    /**
     * The tariff
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Tariff
     */
    public $tariff;
    /**
     * The tariffBreakdown
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\TariffBreakdown
     */
    public $tariffBreakdown;
    /**
     * Constructor method for CreditVendTx
     * @uses CreditVendTx::setCreditTokenIssue()
     * @uses CreditVendTx::setTariff()
     * @uses CreditVendTx::setTariffBreakdown()
     * @param \StructType\CreditTokenIssue $creditTokenIssue
     * @param \StructType\Tariff $tariff
     * @param \StructType\TariffBreakdown $tariffBreakdown
     */
    public function __construct(\StructType\CreditTokenIssue $creditTokenIssue = null, \StructType\Tariff $tariff = null, \StructType\TariffBreakdown $tariffBreakdown = null)
    {
        $this
            ->setCreditTokenIssue($creditTokenIssue)
            ->setTariff($tariff)
            ->setTariffBreakdown($tariffBreakdown);
    }
    /**
     * Get creditTokenIssue value
     * @return \StructType\CreditTokenIssue|null
     */
    public function getCreditTokenIssue()
    {
        return $this->creditTokenIssue;
    }
    /**
     * Set creditTokenIssue value
     * @param \StructType\CreditTokenIssue $creditTokenIssue
     * @return \StructType\CreditVendTx
     */
    public function setCreditTokenIssue(\StructType\CreditTokenIssue $creditTokenIssue = null)
    {
        $this->creditTokenIssue = $creditTokenIssue;
        return $this;
    }
    /**
     * Get tariff value
     * @return \StructType\Tariff|null
     */
    public function getTariff()
    {
        return $this->tariff;
    }
    /**
     * Set tariff value
     * @param \StructType\Tariff $tariff
     * @return \StructType\CreditVendTx
     */
    public function setTariff(\StructType\Tariff $tariff = null)
    {
        $this->tariff = $tariff;
        return $this;
    }
    /**
     * Get tariffBreakdown value
     * @return \StructType\TariffBreakdown|null
     */
    public function getTariffBreakdown()
    {
        return $this->tariffBreakdown;
    }
    /**
     * Set tariffBreakdown value
     * @param \StructType\TariffBreakdown $tariffBreakdown
     * @return \StructType\CreditVendTx
     */
    public function setTariffBreakdown(\StructType\TariffBreakdown $tariffBreakdown = null)
    {
        $this->tariffBreakdown = $tariffBreakdown;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\CreditVendTx
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
