<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Card StructType
 * @subpackage Structs
 */
abstract class Card extends PayType
{
    /**
     * The cardAmt
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Currency
     */
    public $cardAmt;
    /**
     * The accHolderName
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $accHolderName;
    /**
     * The pan
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $pan;
    /**
     * The expDate
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $expDate;
    /**
     * The cvNum
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $cvNum;
    /**
     * The clearingHouse
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $clearingHouse;
    /**
     * Constructor method for Card
     * @uses Card::setCardAmt()
     * @uses Card::setAccHolderName()
     * @uses Card::setPan()
     * @uses Card::setExpDate()
     * @uses Card::setCvNum()
     * @uses Card::setClearingHouse()
     * @param \StructType\Currency $cardAmt
     * @param string $accHolderName
     * @param string $pan
     * @param string $expDate
     * @param string $cvNum
     * @param string $clearingHouse
     */
    public function __construct(\StructType\Currency $cardAmt = null, $accHolderName = null, $pan = null, $expDate = null, $cvNum = null, $clearingHouse = null)
    {
        $this
            ->setCardAmt($cardAmt)
            ->setAccHolderName($accHolderName)
            ->setPan($pan)
            ->setExpDate($expDate)
            ->setCvNum($cvNum)
            ->setClearingHouse($clearingHouse);
    }
    /**
     * Get cardAmt value
     * @return \StructType\Currency|null
     */
    public function getCardAmt()
    {
        return $this->cardAmt;
    }
    /**
     * Set cardAmt value
     * @param \StructType\Currency $cardAmt
     * @return \StructType\Card
     */
    public function setCardAmt(\StructType\Currency $cardAmt = null)
    {
        $this->cardAmt = $cardAmt;
        return $this;
    }
    /**
     * Get accHolderName value
     * @return string|null
     */
    public function getAccHolderName()
    {
        return $this->accHolderName;
    }
    /**
     * Set accHolderName value
     * @param string $accHolderName
     * @return \StructType\Card
     */
    public function setAccHolderName($accHolderName = null)
    {
        // validation for constraint: string
        if (!is_null($accHolderName) && !is_string($accHolderName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($accHolderName)), __LINE__);
        }
        $this->accHolderName = $accHolderName;
        return $this;
    }
    /**
     * Get pan value
     * @return string|null
     */
    public function getPan()
    {
        return $this->pan;
    }
    /**
     * Set pan value
     * @param string $pan
     * @return \StructType\Card
     */
    public function setPan($pan = null)
    {
        // validation for constraint: string
        if (!is_null($pan) && !is_string($pan)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($pan)), __LINE__);
        }
        $this->pan = $pan;
        return $this;
    }
    /**
     * Get expDate value
     * @return string|null
     */
    public function getExpDate()
    {
        return $this->expDate;
    }
    /**
     * Set expDate value
     * @param string $expDate
     * @return \StructType\Card
     */
    public function setExpDate($expDate = null)
    {
        // validation for constraint: string
        if (!is_null($expDate) && !is_string($expDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($expDate)), __LINE__);
        }
        $this->expDate = $expDate;
        return $this;
    }
    /**
     * Get cvNum value
     * @return string|null
     */
    public function getCvNum()
    {
        return $this->cvNum;
    }
    /**
     * Set cvNum value
     * @param string $cvNum
     * @return \StructType\Card
     */
    public function setCvNum($cvNum = null)
    {
        // validation for constraint: string
        if (!is_null($cvNum) && !is_string($cvNum)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($cvNum)), __LINE__);
        }
        $this->cvNum = $cvNum;
        return $this;
    }
    /**
     * Get clearingHouse value
     * @return string|null
     */
    public function getClearingHouse()
    {
        return $this->clearingHouse;
    }
    /**
     * Set clearingHouse value
     * @param string $clearingHouse
     * @return \StructType\Card
     */
    public function setClearingHouse($clearingHouse = null)
    {
        // validation for constraint: string
        if (!is_null($clearingHouse) && !is_string($clearingHouse)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($clearingHouse)), __LINE__);
        }
        $this->clearingHouse = $clearingHouse;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Card
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
