<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Beneficiary StructType
 * @subpackage Structs
 */
class Beneficiary extends AbstractStructBase
{
    /**
     * The accName
     * @var string
     */
    public $accName;
    /**
     * The accNo
     * @var string
     */
    public $accNo;
    /**
     * The branchCode
     * @var string
     */
    public $branchCode;
    /**
     * The bankName
     * @var string
     */
    public $bankName;
    /**
     * The bankRegNo
     * @var string
     */
    public $bankRegNo;
    /**
     * Constructor method for Beneficiary
     * @uses Beneficiary::setAccName()
     * @uses Beneficiary::setAccNo()
     * @uses Beneficiary::setBranchCode()
     * @uses Beneficiary::setBankName()
     * @uses Beneficiary::setBankRegNo()
     * @param string $accName
     * @param string $accNo
     * @param string $branchCode
     * @param string $bankName
     * @param string $bankRegNo
     */
    public function __construct($accName = null, $accNo = null, $branchCode = null, $bankName = null, $bankRegNo = null)
    {
        $this
            ->setAccName($accName)
            ->setAccNo($accNo)
            ->setBranchCode($branchCode)
            ->setBankName($bankName)
            ->setBankRegNo($bankRegNo);
    }
    /**
     * Get accName value
     * @return string|null
     */
    public function getAccName()
    {
        return $this->accName;
    }
    /**
     * Set accName value
     * @param string $accName
     * @return \StructType\Beneficiary
     */
    public function setAccName($accName = null)
    {
        // validation for constraint: string
        if (!is_null($accName) && !is_string($accName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($accName)), __LINE__);
        }
        $this->accName = $accName;
        return $this;
    }
    /**
     * Get accNo value
     * @return string|null
     */
    public function getAccNo()
    {
        return $this->accNo;
    }
    /**
     * Set accNo value
     * @param string $accNo
     * @return \StructType\Beneficiary
     */
    public function setAccNo($accNo = null)
    {
        // validation for constraint: string
        if (!is_null($accNo) && !is_string($accNo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($accNo)), __LINE__);
        }
        $this->accNo = $accNo;
        return $this;
    }
    /**
     * Get branchCode value
     * @return string|null
     */
    public function getBranchCode()
    {
        return $this->branchCode;
    }
    /**
     * Set branchCode value
     * @param string $branchCode
     * @return \StructType\Beneficiary
     */
    public function setBranchCode($branchCode = null)
    {
        // validation for constraint: string
        if (!is_null($branchCode) && !is_string($branchCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($branchCode)), __LINE__);
        }
        $this->branchCode = $branchCode;
        return $this;
    }
    /**
     * Get bankName value
     * @return string|null
     */
    public function getBankName()
    {
        return $this->bankName;
    }
    /**
     * Set bankName value
     * @param string $bankName
     * @return \StructType\Beneficiary
     */
    public function setBankName($bankName = null)
    {
        // validation for constraint: string
        if (!is_null($bankName) && !is_string($bankName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($bankName)), __LINE__);
        }
        $this->bankName = $bankName;
        return $this;
    }
    /**
     * Get bankRegNo value
     * @return string|null
     */
    public function getBankRegNo()
    {
        return $this->bankRegNo;
    }
    /**
     * Set bankRegNo value
     * @param string $bankRegNo
     * @return \StructType\Beneficiary
     */
    public function setBankRegNo($bankRegNo = null)
    {
        // validation for constraint: string
        if (!is_null($bankRegNo) && !is_string($bankRegNo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($bankRegNo)), __LINE__);
        }
        $this->bankRegNo = $bankRegNo;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Beneficiary
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
