<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for BatchStatus StructType
 * @subpackage Structs
 */
class BatchStatus extends AbstractStructBase
{
    /**
     * The banking
     * Meta informations extracted from the WSDL
     * - use: required
     * @var string
     */
    public $banking;
    /**
     * The sales
     * Meta informations extracted from the WSDL
     * - use: required
     * @var string
     */
    public $sales;
    /**
     * The shift
     * Meta informations extracted from the WSDL
     * - use: required
     * @var string
     */
    public $shift;
    /**
     * Constructor method for BatchStatus
     * @uses BatchStatus::setBanking()
     * @uses BatchStatus::setSales()
     * @uses BatchStatus::setShift()
     * @param string $banking
     * @param string $sales
     * @param string $shift
     */
    public function __construct($banking = null, $sales = null, $shift = null)
    {
        $this
            ->setBanking($banking)
            ->setSales($sales)
            ->setShift($shift);
    }
    /**
     * Get banking value
     * @return string
     */
    public function getBanking()
    {
        return $this->banking;
    }
    /**
     * Set banking value
     * @uses \EnumType\BatchStatusType::valueIsValid()
     * @uses \EnumType\BatchStatusType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $banking
     * @return \StructType\BatchStatus
     */
    public function setBanking($banking = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\BatchStatusType::valueIsValid($banking)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $banking, implode(', ', \EnumType\BatchStatusType::getValidValues())), __LINE__);
        }
        $this->banking = $banking;
        return $this;
    }
    /**
     * Get sales value
     * @return string
     */
    public function getSales()
    {
        return $this->sales;
    }
    /**
     * Set sales value
     * @uses \EnumType\BatchStatusType::valueIsValid()
     * @uses \EnumType\BatchStatusType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $sales
     * @return \StructType\BatchStatus
     */
    public function setSales($sales = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\BatchStatusType::valueIsValid($sales)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $sales, implode(', ', \EnumType\BatchStatusType::getValidValues())), __LINE__);
        }
        $this->sales = $sales;
        return $this;
    }
    /**
     * Get shift value
     * @return string
     */
    public function getShift()
    {
        return $this->shift;
    }
    /**
     * Set shift value
     * @uses \EnumType\BatchStatusType::valueIsValid()
     * @uses \EnumType\BatchStatusType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $shift
     * @return \StructType\BatchStatus
     */
    public function setShift($shift = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\BatchStatusType::valueIsValid($shift)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $shift, implode(', ', \EnumType\BatchStatusType::getValidValues())), __LINE__);
        }
        $this->shift = $shift;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\BatchStatus
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
