<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Batch StructType
 * @subpackage Structs
 */
abstract class Batch extends AbstractStructBase
{
    /**
     * The started
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $started;
    /**
     * The ended
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $ended;
    /**
     * The batchTot
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Currency
     */
    public $batchTot;
    /**
     * The totTax
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Tax
     */
    public $totTax;
    /**
     * The batchReport
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\BatchReport
     */
    public $batchReport;
    /**
     * Constructor method for Batch
     * @uses Batch::setStarted()
     * @uses Batch::setEnded()
     * @uses Batch::setBatchTot()
     * @uses Batch::setTotTax()
     * @uses Batch::setBatchReport()
     * @param string $started
     * @param string $ended
     * @param \StructType\Currency $batchTot
     * @param \StructType\Tax $totTax
     * @param \StructType\BatchReport $batchReport
     */
    public function __construct($started = null, $ended = null, \StructType\Currency $batchTot = null, \StructType\Tax $totTax = null, \StructType\BatchReport $batchReport = null)
    {
        $this
            ->setStarted($started)
            ->setEnded($ended)
            ->setBatchTot($batchTot)
            ->setTotTax($totTax)
            ->setBatchReport($batchReport);
    }
    /**
     * Get started value
     * @return string
     */
    public function getStarted()
    {
        return $this->started;
    }
    /**
     * Set started value
     * @param string $started
     * @return \StructType\Batch
     */
    public function setStarted($started = null)
    {
        // validation for constraint: string
        if (!is_null($started) && !is_string($started)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($started)), __LINE__);
        }
        $this->started = $started;
        return $this;
    }
    /**
     * Get ended value
     * @return string
     */
    public function getEnded()
    {
        return $this->ended;
    }
    /**
     * Set ended value
     * @param string $ended
     * @return \StructType\Batch
     */
    public function setEnded($ended = null)
    {
        // validation for constraint: string
        if (!is_null($ended) && !is_string($ended)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($ended)), __LINE__);
        }
        $this->ended = $ended;
        return $this;
    }
    /**
     * Get batchTot value
     * @return \StructType\Currency|null
     */
    public function getBatchTot()
    {
        return $this->batchTot;
    }
    /**
     * Set batchTot value
     * @param \StructType\Currency $batchTot
     * @return \StructType\Batch
     */
    public function setBatchTot(\StructType\Currency $batchTot = null)
    {
        $this->batchTot = $batchTot;
        return $this;
    }
    /**
     * Get totTax value
     * @return \StructType\Tax|null
     */
    public function getTotTax()
    {
        return $this->totTax;
    }
    /**
     * Set totTax value
     * @param \StructType\Tax $totTax
     * @return \StructType\Batch
     */
    public function setTotTax(\StructType\Tax $totTax = null)
    {
        $this->totTax = $totTax;
        return $this;
    }
    /**
     * Get batchReport value
     * @return \StructType\BatchReport|null
     */
    public function getBatchReport()
    {
        return $this->batchReport;
    }
    /**
     * Set batchReport value
     * @param \StructType\BatchReport $batchReport
     * @return \StructType\Batch
     */
    public function setBatchReport(\StructType\BatchReport $batchReport = null)
    {
        $this->batchReport = $batchReport;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Batch
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
