<?php

namespace EnumType;

/**
 * This class stands for TokenTypes EnumType
 * @subpackage Enumerations
 */
class TokenTypes
{
    /**
     * Constant for value 'CreditVend'
     * @return string 'CreditVend'
     */
    const VALUE_CREDIT_VEND = 'CreditVend';
    /**
     * Constant for value 'FreeBasicElectricity'
     * @return string 'FreeBasicElectricity'
     */
    const VALUE_FREE_BASIC_ELECTRICITY = 'FreeBasicElectricity';
    /**
     * Constant for value 'KeyChange1'
     * @return string 'KeyChange1'
     */
    const VALUE_KEY_CHANGE_1 = 'KeyChange1';
    /**
     * Constant for value 'KeyChange2'
     * @return string 'KeyChange2'
     */
    const VALUE_KEY_CHANGE_2 = 'KeyChange2';
    /**
     * Constant for value 'Verification'
     * @return string 'Verification'
     */
    const VALUE_VERIFICATION = 'Verification';
    /**
     * Constant for value 'UnknownNonMeterSpecificEng'
     * @return string 'UnknownNonMeterSpecificEng'
     */
    const VALUE_UNKNOWN_NON_METER_SPECIFIC_ENG = 'UnknownNonMeterSpecificEng';
    /**
     * Constant for value 'DispenserTest'
     * @return string 'DispenserTest'
     */
    const VALUE_DISPENSER_TEST = 'DispenserTest';
    /**
     * Constant for value 'DisplayRegisterTotals'
     * @return string 'DisplayRegisterTotals'
     */
    const VALUE_DISPLAY_REGISTER_TOTALS = 'DisplayRegisterTotals';
    /**
     * Constant for value 'DisplayKeyRevision'
     * @return string 'DisplayKeyRevision'
     */
    const VALUE_DISPLAY_KEY_REVISION = 'DisplayKeyRevision';
    /**
     * Constant for value 'DisplayTariffIndex'
     * @return string 'DisplayTariffIndex'
     */
    const VALUE_DISPLAY_TARIFF_INDEX = 'DisplayTariffIndex';
    /**
     * Constant for value 'DisplayMaxPowerLimit'
     * @return string 'DisplayMaxPowerLimit'
     */
    const VALUE_DISPLAY_MAX_POWER_LIMIT = 'DisplayMaxPowerLimit';
    /**
     * Constant for value 'DisplayTamperStatus'
     * @return string 'DisplayTamperStatus'
     */
    const VALUE_DISPLAY_TAMPER_STATUS = 'DisplayTamperStatus';
    /**
     * Constant for value 'DisplayPowerConsumption'
     * @return string 'DisplayPowerConsumption'
     */
    const VALUE_DISPLAY_POWER_CONSUMPTION = 'DisplayPowerConsumption';
    /**
     * Constant for value 'DisplayMeterVersion'
     * @return string 'DisplayMeterVersion'
     */
    const VALUE_DISPLAY_METER_VERSION = 'DisplayMeterVersion';
    /**
     * Constant for value 'DisplayPowerUnbalanceLimit'
     * @return string 'DisplayPowerUnbalanceLimit'
     */
    const VALUE_DISPLAY_POWER_UNBALANCE_LIMIT = 'DisplayPowerUnbalanceLimit';
    /**
     * Constant for value 'TestDisplayIndicators'
     * @return string 'TestDisplayIndicators'
     */
    const VALUE_TEST_DISPLAY_INDICATORS = 'TestDisplayIndicators';
    /**
     * Constant for value 'NonDispenserSpecific11'
     * @return string 'NonDispenserSpecific11'
     */
    const VALUE_NON_DISPENSER_SPECIFIC_11 = 'NonDispenserSpecific11';
    /**
     * Constant for value 'TestDisconnectionDevice'
     * @return string 'TestDisconnectionDevice'
     */
    const VALUE_TEST_DISCONNECTION_DEVICE = 'TestDisconnectionDevice';
    /**
     * Constant for value 'UnknownMeterSpecificEng'
     * @return string 'UnknownMeterSpecificEng'
     */
    const VALUE_UNKNOWN_METER_SPECIFIC_ENG = 'UnknownMeterSpecificEng';
    /**
     * Constant for value 'MeterSpecificEngKCTReq'
     * @return string 'MeterSpecificEngKCTReq'
     */
    const VALUE_METER_SPECIFIC_ENG_KCTREQ = 'MeterSpecificEngKCTReq';
    /**
     * Constant for value 'MeterSpecificEngClearTamper'
     * @return string 'MeterSpecificEngClearTamper'
     */
    const VALUE_METER_SPECIFIC_ENG_CLEAR_TAMPER = 'MeterSpecificEngClearTamper';
    /**
     * Constant for value 'MeterSpecificEngClearCredit'
     * @return string 'MeterSpecificEngClearCredit'
     */
    const VALUE_METER_SPECIFIC_ENG_CLEAR_CREDIT = 'MeterSpecificEngClearCredit';
    /**
     * Constant for value 'MeterSpecificEngClearAllCredit'
     * @return string 'MeterSpecificEngClearAllCredit'
     */
    const VALUE_METER_SPECIFIC_ENG_CLEAR_ALL_CREDIT = 'MeterSpecificEngClearAllCredit';
    /**
     * Constant for value 'MeterSpecificEngPhUnbal'
     * @return string 'MeterSpecificEngPhUnbal'
     */
    const VALUE_METER_SPECIFIC_ENG_PH_UNBAL = 'MeterSpecificEngPhUnbal';
    /**
     * Constant for value 'MeterSpecificEngPwrLmt'
     * @return string 'MeterSpecificEngPwrLmt'
     */
    const VALUE_METER_SPECIFIC_ENG_PWR_LMT = 'MeterSpecificEngPwrLmt';
    /**
     * Constant for value 'CmftUnknown'
     * @return string 'CmftUnknown'
     */
    const VALUE_CMFT_UNKNOWN = 'CmftUnknown';
    /**
     * Constant for value 'CmftEnableTamperDetection'
     * @return string 'CmftEnableTamperDetection'
     */
    const VALUE_CMFT_ENABLE_TAMPER_DETECTION = 'CmftEnableTamperDetection';
    /**
     * Constant for value 'CmftDisableTamperDetection'
     * @return string 'CmftDisableTamperDetection'
     */
    const VALUE_CMFT_DISABLE_TAMPER_DETECTION = 'CmftDisableTamperDetection';
    /**
     * Constant for value 'CmftPrepaymentToPostPayment'
     * @return string 'CmftPrepaymentToPostPayment'
     */
    const VALUE_CMFT_PREPAYMENT_TO_POST_PAYMENT = 'CmftPrepaymentToPostPayment';
    /**
     * Constant for value 'CmftPostpaymentToPrePayment'
     * @return string 'CmftPostpaymentToPrePayment'
     */
    const VALUE_CMFT_POSTPAYMENT_TO_PRE_PAYMENT = 'CmftPostpaymentToPrePayment';
    /**
     * Constant for value 'CmftRemoteDisconnect'
     * @return string 'CmftRemoteDisconnect'
     */
    const VALUE_CMFT_REMOTE_DISCONNECT = 'CmftRemoteDisconnect';
    /**
     * Constant for value 'CmftRemoteReconnect'
     * @return string 'CmftRemoteReconnect'
     */
    const VALUE_CMFT_REMOTE_RECONNECT = 'CmftRemoteReconnect';
    /**
     * Constant for value 'CmftEnableUnderVoltage'
     * @return string 'CmftEnableUnderVoltage'
     */
    const VALUE_CMFT_ENABLE_UNDER_VOLTAGE = 'CmftEnableUnderVoltage';
    /**
     * Constant for value 'CmftDisableUnderVoltage'
     * @return string 'CmftDisableUnderVoltage'
     */
    const VALUE_CMFT_DISABLE_UNDER_VOLTAGE = 'CmftDisableUnderVoltage';
    /**
     * Constant for value 'CmftEnableOverVoltage'
     * @return string 'CmftEnableOverVoltage'
     */
    const VALUE_CMFT_ENABLE_OVER_VOLTAGE = 'CmftEnableOverVoltage';
    /**
     * Constant for value 'CmftDisableOverVoltage'
     * @return string 'CmftDisableOverVoltage'
     */
    const VALUE_CMFT_DISABLE_OVER_VOLTAGE = 'CmftDisableOverVoltage';
    /**
     * Constant for value 'CmftDecommission'
     * @return string 'CmftDecommission'
     */
    const VALUE_CMFT_DECOMMISSION = 'CmftDecommission';
    /**
     * Constant for value 'CmftEnterServiceConfigurationMode'
     * @return string 'CmftEnterServiceConfigurationMode'
     */
    const VALUE_CMFT_ENTER_SERVICE_CONFIGURATION_MODE = 'CmftEnterServiceConfigurationMode';
    /**
     * Constant for value 'CmftDisableAdministrationMode'
     * @return string 'CmftDisableAdministrationMode'
     */
    const VALUE_CMFT_DISABLE_ADMINISTRATION_MODE = 'CmftDisableAdministrationMode';
    /**
     * Constant for value 'CmftEnableAdministrationMode'
     * @return string 'CmftEnableAdministrationMode'
     */
    const VALUE_CMFT_ENABLE_ADMINISTRATION_MODE = 'CmftEnableAdministrationMode';
    /**
     * Constant for value 'CmftEnableNegativeCreditDisplay'
     * @return string 'CmftEnableNegativeCreditDisplay'
     */
    const VALUE_CMFT_ENABLE_NEGATIVE_CREDIT_DISPLAY = 'CmftEnableNegativeCreditDisplay';
    /**
     * Constant for value 'CmftDisableNegativeCreditDisplay'
     * @return string 'CmftDisableNegativeCreditDisplay'
     */
    const VALUE_CMFT_DISABLE_NEGATIVE_CREDIT_DISPLAY = 'CmftDisableNegativeCreditDisplay';
    /**
     * Constant for value 'CmftEnableRandomConnection'
     * @return string 'CmftEnableRandomConnection'
     */
    const VALUE_CMFT_ENABLE_RANDOM_CONNECTION = 'CmftEnableRandomConnection';
    /**
     * Constant for value 'CmftDisableRandomConnection'
     * @return string 'CmftDisableRandomConnection'
     */
    const VALUE_CMFT_DISABLE_RANDOM_CONNECTION = 'CmftDisableRandomConnection';
    /**
     * Constant for value 'CmftEnableConsumptionRestriction'
     * @return string 'CmftEnableConsumptionRestriction'
     */
    const VALUE_CMFT_ENABLE_CONSUMPTION_RESTRICTION = 'CmftEnableConsumptionRestriction';
    /**
     * Constant for value 'CmftDisableConsumptionRestriction'
     * @return string 'CmftDisableConsumptionRestriction'
     */
    const VALUE_CMFT_DISABLE_CONSUMPTION_RESTRICTION = 'CmftDisableConsumptionRestriction';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_CREDIT_VEND
     * @uses self::VALUE_FREE_BASIC_ELECTRICITY
     * @uses self::VALUE_KEY_CHANGE_1
     * @uses self::VALUE_KEY_CHANGE_2
     * @uses self::VALUE_VERIFICATION
     * @uses self::VALUE_UNKNOWN_NON_METER_SPECIFIC_ENG
     * @uses self::VALUE_DISPENSER_TEST
     * @uses self::VALUE_DISPLAY_REGISTER_TOTALS
     * @uses self::VALUE_DISPLAY_KEY_REVISION
     * @uses self::VALUE_DISPLAY_TARIFF_INDEX
     * @uses self::VALUE_DISPLAY_MAX_POWER_LIMIT
     * @uses self::VALUE_DISPLAY_TAMPER_STATUS
     * @uses self::VALUE_DISPLAY_POWER_CONSUMPTION
     * @uses self::VALUE_DISPLAY_METER_VERSION
     * @uses self::VALUE_DISPLAY_POWER_UNBALANCE_LIMIT
     * @uses self::VALUE_TEST_DISPLAY_INDICATORS
     * @uses self::VALUE_NON_DISPENSER_SPECIFIC_11
     * @uses self::VALUE_TEST_DISCONNECTION_DEVICE
     * @uses self::VALUE_UNKNOWN_METER_SPECIFIC_ENG
     * @uses self::VALUE_METER_SPECIFIC_ENG_KCTREQ
     * @uses self::VALUE_METER_SPECIFIC_ENG_CLEAR_TAMPER
     * @uses self::VALUE_METER_SPECIFIC_ENG_CLEAR_CREDIT
     * @uses self::VALUE_METER_SPECIFIC_ENG_CLEAR_ALL_CREDIT
     * @uses self::VALUE_METER_SPECIFIC_ENG_PH_UNBAL
     * @uses self::VALUE_METER_SPECIFIC_ENG_PWR_LMT
     * @uses self::VALUE_CMFT_UNKNOWN
     * @uses self::VALUE_CMFT_ENABLE_TAMPER_DETECTION
     * @uses self::VALUE_CMFT_DISABLE_TAMPER_DETECTION
     * @uses self::VALUE_CMFT_PREPAYMENT_TO_POST_PAYMENT
     * @uses self::VALUE_CMFT_POSTPAYMENT_TO_PRE_PAYMENT
     * @uses self::VALUE_CMFT_REMOTE_DISCONNECT
     * @uses self::VALUE_CMFT_REMOTE_RECONNECT
     * @uses self::VALUE_CMFT_ENABLE_UNDER_VOLTAGE
     * @uses self::VALUE_CMFT_DISABLE_UNDER_VOLTAGE
     * @uses self::VALUE_CMFT_ENABLE_OVER_VOLTAGE
     * @uses self::VALUE_CMFT_DISABLE_OVER_VOLTAGE
     * @uses self::VALUE_CMFT_DECOMMISSION
     * @uses self::VALUE_CMFT_ENTER_SERVICE_CONFIGURATION_MODE
     * @uses self::VALUE_CMFT_DISABLE_ADMINISTRATION_MODE
     * @uses self::VALUE_CMFT_ENABLE_ADMINISTRATION_MODE
     * @uses self::VALUE_CMFT_ENABLE_NEGATIVE_CREDIT_DISPLAY
     * @uses self::VALUE_CMFT_DISABLE_NEGATIVE_CREDIT_DISPLAY
     * @uses self::VALUE_CMFT_ENABLE_RANDOM_CONNECTION
     * @uses self::VALUE_CMFT_DISABLE_RANDOM_CONNECTION
     * @uses self::VALUE_CMFT_ENABLE_CONSUMPTION_RESTRICTION
     * @uses self::VALUE_CMFT_DISABLE_CONSUMPTION_RESTRICTION
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_CREDIT_VEND,
            self::VALUE_FREE_BASIC_ELECTRICITY,
            self::VALUE_KEY_CHANGE_1,
            self::VALUE_KEY_CHANGE_2,
            self::VALUE_VERIFICATION,
            self::VALUE_UNKNOWN_NON_METER_SPECIFIC_ENG,
            self::VALUE_DISPENSER_TEST,
            self::VALUE_DISPLAY_REGISTER_TOTALS,
            self::VALUE_DISPLAY_KEY_REVISION,
            self::VALUE_DISPLAY_TARIFF_INDEX,
            self::VALUE_DISPLAY_MAX_POWER_LIMIT,
            self::VALUE_DISPLAY_TAMPER_STATUS,
            self::VALUE_DISPLAY_POWER_CONSUMPTION,
            self::VALUE_DISPLAY_METER_VERSION,
            self::VALUE_DISPLAY_POWER_UNBALANCE_LIMIT,
            self::VALUE_TEST_DISPLAY_INDICATORS,
            self::VALUE_NON_DISPENSER_SPECIFIC_11,
            self::VALUE_TEST_DISCONNECTION_DEVICE,
            self::VALUE_UNKNOWN_METER_SPECIFIC_ENG,
            self::VALUE_METER_SPECIFIC_ENG_KCTREQ,
            self::VALUE_METER_SPECIFIC_ENG_CLEAR_TAMPER,
            self::VALUE_METER_SPECIFIC_ENG_CLEAR_CREDIT,
            self::VALUE_METER_SPECIFIC_ENG_CLEAR_ALL_CREDIT,
            self::VALUE_METER_SPECIFIC_ENG_PH_UNBAL,
            self::VALUE_METER_SPECIFIC_ENG_PWR_LMT,
            self::VALUE_CMFT_UNKNOWN,
            self::VALUE_CMFT_ENABLE_TAMPER_DETECTION,
            self::VALUE_CMFT_DISABLE_TAMPER_DETECTION,
            self::VALUE_CMFT_PREPAYMENT_TO_POST_PAYMENT,
            self::VALUE_CMFT_POSTPAYMENT_TO_PRE_PAYMENT,
            self::VALUE_CMFT_REMOTE_DISCONNECT,
            self::VALUE_CMFT_REMOTE_RECONNECT,
            self::VALUE_CMFT_ENABLE_UNDER_VOLTAGE,
            self::VALUE_CMFT_DISABLE_UNDER_VOLTAGE,
            self::VALUE_CMFT_ENABLE_OVER_VOLTAGE,
            self::VALUE_CMFT_DISABLE_OVER_VOLTAGE,
            self::VALUE_CMFT_DECOMMISSION,
            self::VALUE_CMFT_ENTER_SERVICE_CONFIGURATION_MODE,
            self::VALUE_CMFT_DISABLE_ADMINISTRATION_MODE,
            self::VALUE_CMFT_ENABLE_ADMINISTRATION_MODE,
            self::VALUE_CMFT_ENABLE_NEGATIVE_CREDIT_DISPLAY,
            self::VALUE_CMFT_DISABLE_NEGATIVE_CREDIT_DISPLAY,
            self::VALUE_CMFT_ENABLE_RANDOM_CONNECTION,
            self::VALUE_CMFT_DISABLE_RANDOM_CONNECTION,
            self::VALUE_CMFT_ENABLE_CONSUMPTION_RESTRICTION,
            self::VALUE_CMFT_DISABLE_CONSUMPTION_RESTRICTION,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
