<?php

namespace EnumType;

/**
 * This class stands for NonMeterSpecificEng EnumType
 * @subpackage Enumerations
 */
class NonMeterSpecificEng
{
    /**
     * Constant for value 'TestAll'
     * @return string 'TestAll'
     */
    const VALUE_TEST_ALL = 'TestAll';
    /**
     * Constant for value 'TestBreaker'
     * @return string 'TestBreaker'
     */
    const VALUE_TEST_BREAKER = 'TestBreaker';
    /**
     * Constant for value 'TestDisp'
     * @return string 'TestDisp'
     */
    const VALUE_TEST_DISP = 'TestDisp';
    /**
     * Constant for value 'DispPwrLmt'
     * @return string 'DispPwrLmt'
     */
    const VALUE_DISP_PWR_LMT = 'DispPwrLmt';
    /**
     * Constant for value 'DispTI'
     * @return string 'DispTI'
     */
    const VALUE_DISP_TI = 'DispTI';
    /**
     * Constant for value 'DispKRN'
     * @return string 'DispKRN'
     */
    const VALUE_DISP_KRN = 'DispKRN';
    /**
     * Constant for value 'DispTamper'
     * @return string 'DispTamper'
     */
    const VALUE_DISP_TAMPER = 'DispTamper';
    /**
     * Constant for value 'DispInstPwr'
     * @return string 'DispInstPwr'
     */
    const VALUE_DISP_INST_PWR = 'DispInstPwr';
    /**
     * Constant for value 'DispConsTot'
     * @return string 'DispConsTot'
     */
    const VALUE_DISP_CONS_TOT = 'DispConsTot';
    /**
     * Constant for value 'DispUnbalance'
     * @return string 'DispUnbalance'
     */
    const VALUE_DISP_UNBALANCE = 'DispUnbalance';
    /**
     * Constant for value 'DispVer'
     * @return string 'DispVer'
     */
    const VALUE_DISP_VER = 'DispVer';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_TEST_ALL
     * @uses self::VALUE_TEST_BREAKER
     * @uses self::VALUE_TEST_DISP
     * @uses self::VALUE_DISP_PWR_LMT
     * @uses self::VALUE_DISP_TI
     * @uses self::VALUE_DISP_KRN
     * @uses self::VALUE_DISP_TAMPER
     * @uses self::VALUE_DISP_INST_PWR
     * @uses self::VALUE_DISP_CONS_TOT
     * @uses self::VALUE_DISP_UNBALANCE
     * @uses self::VALUE_DISP_VER
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_TEST_ALL,
            self::VALUE_TEST_BREAKER,
            self::VALUE_TEST_DISP,
            self::VALUE_DISP_PWR_LMT,
            self::VALUE_DISP_TI,
            self::VALUE_DISP_KRN,
            self::VALUE_DISP_TAMPER,
            self::VALUE_DISP_INST_PWR,
            self::VALUE_DISP_CONS_TOT,
            self::VALUE_DISP_UNBALANCE,
            self::VALUE_DISP_VER,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
