<?php

namespace EnumType;

/**
 * This class stands for CreditTokenSubClassType EnumType
 * @subpackage Enumerations
 */
class CreditTokenSubClassType
{
    /**
     * Constant for value 'Electricity Token'
     * @return string 'Electricity Token'
     */
    const VALUE_ELECTRICITY_TOKEN = 'Electricity Token';
    /**
     * Constant for value 'Water Token'
     * @return string 'Water Token'
     */
    const VALUE_WATER_TOKEN = 'Water Token';
    /**
     * Constant for value 'Gas Token'
     * @return string 'Gas Token'
     */
    const VALUE_GAS_TOKEN = 'Gas Token';
    /**
     * Constant for value 'Connection time Token'
     * @return string 'Connection time Token'
     */
    const VALUE_CONNECTION_TIME_TOKEN = 'Connection time Token';
    /**
     * Constant for value 'Currency Token'
     * @return string 'Currency Token'
     */
    const VALUE_CURRENCY_TOKEN = 'Currency Token';
    /**
     * Return true if value is allowed
     * @uses self::getValidValues()
     * @param mixed $value value
     * @return bool true|false
     */
    public static function valueIsValid($value)
    {
        return ($value === null) || in_array($value, self::getValidValues(), true);
    }
    /**
     * Return allowed values
     * @uses self::VALUE_ELECTRICITY_TOKEN
     * @uses self::VALUE_WATER_TOKEN
     * @uses self::VALUE_GAS_TOKEN
     * @uses self::VALUE_CONNECTION_TIME_TOKEN
     * @uses self::VALUE_CURRENCY_TOKEN
     * @return string[]
     */
    public static function getValidValues()
    {
        return array(
            self::VALUE_ELECTRICITY_TOKEN,
            self::VALUE_WATER_TOKEN,
            self::VALUE_GAS_TOKEN,
            self::VALUE_CONNECTION_TIME_TOKEN,
            self::VALUE_CURRENCY_TOKEN,
        );
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
