<?php
/**
 * This file aims to show you how to use this generated package.
 * In addition, the goal is to show which methods are available and the fist needed parameter(s)
 * You have to use an associative array such as:
 * - the key must be a constant beginning with WSDL_ from AbstractSoapClientbase class each generated ServiceType class extends this class
 * - the value must be the corresponding key value (each option matches a {@link http://www.php.net/manual/en/soapclient.soapclient.php} option)
 * $options = array(
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'http://ppst.botswanapost.co.bw/PrepaidElectricity/VendingService.asmx?WSDL',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_TRACE => true,
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_LOGIN => 'you_secret_login',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_PASSWORD => 'you_secret_password',
 * );
 * etc....
 */
require_once __DIR__ . '/vendor/autoload.php';
/**
 * Minimal options
 */
$options = array(
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'http://ppst.botswanapost.co.bw/PrepaidElectricity/VendingService.asmx?WSDL',
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_CLASSMAP => ClassMap::get(),
);
/**
 * Samples for Reprint ServiceType
 */
$reprint = new \ServiceType\Reprint($options);
/**
 * Sample call for ReprintRequest operation/method
 */
if ($reprint->ReprintRequest(new \StructType\ReprintRequest()) !== false) {
    print_r($reprint->getResult());
} else {
    print_r($reprint->getLastError());
}
/**
 * Samples for Advice ServiceType
 */
$advice = new \ServiceType\Advice($options);
/**
 * Sample call for AdviceRequest operation/method
 */
if ($advice->AdviceRequest(new \StructType\AdviceRequest()) !== false) {
    print_r($advice->getResult());
} else {
    print_r($advice->getLastError());
}
/**
 * Samples for Trial ServiceType
 */
$trial = new \ServiceType\Trial($options);
/**
 * Sample call for TrialCreditVendRequest operation/method
 */
if ($trial->TrialCreditVendRequest(new \StructType\TrialCreditVendRequest()) !== false) {
    print_r($trial->getResult());
} else {
    print_r($trial->getLastError());
}
/**
 * Samples for Credit ServiceType
 */
$credit = new \ServiceType\Credit($options);
/**
 * Sample call for CreditVendRequest operation/method
 */
if ($credit->CreditVendRequest(new \StructType\CreditVendRequest()) !== false) {
    print_r($credit->getResult());
} else {
    print_r($credit->getLastError());
}
/**
 * Samples for Confirm ServiceType
 */
$confirm = new \ServiceType\Confirm($options);
/**
 * Sample call for ConfirmCustomerRequest operation/method
 */
if ($confirm->ConfirmCustomerRequest(new \StructType\ConfirmCustomerRequest()) !== false) {
    print_r($confirm->getResult());
} else {
    print_r($confirm->getLastError());
}
