<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UtilityDetail StructType
 * @subpackage Structs
 */
class UtilityDetail extends AbstractStructBase
{
    /**
     * The name
     * @var string
     */
    public $name;
    /**
     * The address
     * @var string
     */
    public $address;
    /**
     * The taxRef
     * @var string
     */
    public $taxRef;
    /**
     * Constructor method for UtilityDetail
     * @uses UtilityDetail::setName()
     * @uses UtilityDetail::setAddress()
     * @uses UtilityDetail::setTaxRef()
     * @param string $name
     * @param string $address
     * @param string $taxRef
     */
    public function __construct($name = null, $address = null, $taxRef = null)
    {
        $this
            ->setName($name)
            ->setAddress($address)
            ->setTaxRef($taxRef);
    }
    /**
     * Get name value
     * @return string|null
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return \StructType\UtilityDetail
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($name)), __LINE__);
        }
        $this->name = $name;
        return $this;
    }
    /**
     * Get address value
     * @return string|null
     */
    public function getAddress()
    {
        return $this->address;
    }
    /**
     * Set address value
     * @param string $address
     * @return \StructType\UtilityDetail
     */
    public function setAddress($address = null)
    {
        // validation for constraint: string
        if (!is_null($address) && !is_string($address)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($address)), __LINE__);
        }
        $this->address = $address;
        return $this;
    }
    /**
     * Get taxRef value
     * @return string|null
     */
    public function getTaxRef()
    {
        return $this->taxRef;
    }
    /**
     * Set taxRef value
     * @param string $taxRef
     * @return \StructType\UtilityDetail
     */
    public function setTaxRef($taxRef = null)
    {
        // validation for constraint: string
        if (!is_null($taxRef) && !is_string($taxRef)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($taxRef)), __LINE__);
        }
        $this->taxRef = $taxRef;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\UtilityDetail
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
