<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ReverseMerchantDepositResp StructType
 * @subpackage Structs
 */
class ReverseMerchantDepositResp extends BaseResp
{
    /**
     * The DepositSuccessful
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $DepositSuccessful;
    /**
     * The TransactionReference
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $TransactionReference;
    /**
     * Constructor method for ReverseMerchantDepositResp
     * @uses ReverseMerchantDepositResp::setDepositSuccessful()
     * @uses ReverseMerchantDepositResp::setTransactionReference()
     * @param bool $depositSuccessful
     * @param string $transactionReference
     */
    public function __construct($depositSuccessful = null, $transactionReference = null)
    {
        $this
            ->setDepositSuccessful($depositSuccessful)
            ->setTransactionReference($transactionReference);
    }
    /**
     * Get DepositSuccessful value
     * @return bool
     */
    public function getDepositSuccessful()
    {
        return $this->DepositSuccessful;
    }
    /**
     * Set DepositSuccessful value
     * @param bool $depositSuccessful
     * @return \StructType\ReverseMerchantDepositResp
     */
    public function setDepositSuccessful($depositSuccessful = null)
    {
        // validation for constraint: boolean
        if (!is_null($depositSuccessful) && !is_bool($depositSuccessful)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($depositSuccessful)), __LINE__);
        }
        $this->DepositSuccessful = $depositSuccessful;
        return $this;
    }
    /**
     * Get TransactionReference value
     * @return string|null
     */
    public function getTransactionReference()
    {
        return $this->TransactionReference;
    }
    /**
     * Set TransactionReference value
     * @param string $transactionReference
     * @return \StructType\ReverseMerchantDepositResp
     */
    public function setTransactionReference($transactionReference = null)
    {
        // validation for constraint: string
        if (!is_null($transactionReference) && !is_string($transactionReference)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($transactionReference)), __LINE__);
        }
        $this->TransactionReference = $transactionReference;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ReverseMerchantDepositResp
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
