<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ReprintResp StructType
 * @subpackage Structs
 */
class ReprintResp extends BaseResp
{
    /**
     * The reprint
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\BaseVendResp[]
     */
    public $reprint;
    /**
     * Constructor method for ReprintResp
     * @uses ReprintResp::setReprint()
     * @param \StructType\BaseVendResp[] $reprint
     */
    public function __construct(array $reprint = array())
    {
        $this
            ->setReprint($reprint);
    }
    /**
     * Get reprint value
     * @return \StructType\BaseVendResp[]|null
     */
    public function getReprint()
    {
        return $this->reprint;
    }
    /**
     * Set reprint value
     * @throws \InvalidArgumentException
     * @param \StructType\BaseVendResp[] $reprint
     * @return \StructType\ReprintResp
     */
    public function setReprint(array $reprint = array())
    {
        foreach ($reprint as $reprintRespReprintItem) {
            // validation for constraint: itemType
            if (!$reprintRespReprintItem instanceof \StructType\BaseVendResp) {
                throw new \InvalidArgumentException(sprintf('The reprint property can only contain items of \StructType\BaseVendResp, "%s" given', is_object($reprintRespReprintItem) ? get_class($reprintRespReprintItem) : gettype($reprintRespReprintItem)), __LINE__);
            }
        }
        $this->reprint = $reprint;
        return $this;
    }
    /**
     * Add item to reprint value
     * @throws \InvalidArgumentException
     * @param \StructType\BaseVendResp $item
     * @return \StructType\ReprintResp
     */
    public function addToReprint(\StructType\BaseVendResp $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\BaseVendResp) {
            throw new \InvalidArgumentException(sprintf('The reprint property can only contain items of \StructType\BaseVendResp, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->reprint[] = $item;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ReprintResp
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
