<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for MeterAccount StructType
 * @subpackage Structs
 */
class MeterAccount extends MeterIdentifier
{
    /**
     * The isSmartCard
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $isSmartCard;
    /**
     * The AccNo
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $AccNo;
    /**
     * Constructor method for MeterAccount
     * @uses MeterAccount::setIsSmartCard()
     * @uses MeterAccount::setAccNo()
     * @param bool $isSmartCard
     * @param string $accNo
     */
    public function __construct($isSmartCard = null, $accNo = null)
    {
        $this
            ->setIsSmartCard($isSmartCard)
            ->setAccNo($accNo);
    }
    /**
     * Get isSmartCard value
     * @return bool
     */
    public function getIsSmartCard()
    {
        return $this->isSmartCard;
    }
    /**
     * Set isSmartCard value
     * @param bool $isSmartCard
     * @return \StructType\MeterAccount
     */
    public function setIsSmartCard($isSmartCard = null)
    {
        // validation for constraint: boolean
        if (!is_null($isSmartCard) && !is_bool($isSmartCard)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($isSmartCard)), __LINE__);
        }
        $this->isSmartCard = $isSmartCard;
        return $this;
    }
    /**
     * Get AccNo value
     * @return string|null
     */
    public function getAccNo()
    {
        return $this->AccNo;
    }
    /**
     * Set AccNo value
     * @param string $accNo
     * @return \StructType\MeterAccount
     */
    public function setAccNo($accNo = null)
    {
        // validation for constraint: string
        if (!is_null($accNo) && !is_string($accNo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($accNo)), __LINE__);
        }
        $this->AccNo = $accNo;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\MeterAccount
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
