<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DepositCreditUpdate StructType
 * @subpackage Structs
 */
class DepositCreditUpdate extends CredUpdate
{
    /**
     * The depositDate
     * Meta informations extracted from the WSDL
     * - use: required
     * @var string
     */
    public $depositDate;
    /**
     * The depositRefNo
     * @var string
     */
    public $depositRefNo;
    /**
     * Constructor method for DepositCreditUpdate
     * @uses DepositCreditUpdate::setDepositDate()
     * @uses DepositCreditUpdate::setDepositRefNo()
     * @param string $depositDate
     * @param string $depositRefNo
     */
    public function __construct($depositDate = null, $depositRefNo = null)
    {
        $this
            ->setDepositDate($depositDate)
            ->setDepositRefNo($depositRefNo);
    }
    /**
     * Get depositDate value
     * @return string
     */
    public function getDepositDate()
    {
        return $this->depositDate;
    }
    /**
     * Set depositDate value
     * @param string $depositDate
     * @return \StructType\DepositCreditUpdate
     */
    public function setDepositDate($depositDate = null)
    {
        // validation for constraint: string
        if (!is_null($depositDate) && !is_string($depositDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($depositDate)), __LINE__);
        }
        $this->depositDate = $depositDate;
        return $this;
    }
    /**
     * Get depositRefNo value
     * @return string|null
     */
    public function getDepositRefNo()
    {
        return $this->depositRefNo;
    }
    /**
     * Set depositRefNo value
     * @param string $depositRefNo
     * @return \StructType\DepositCreditUpdate
     */
    public function setDepositRefNo($depositRefNo = null)
    {
        // validation for constraint: string
        if (!is_null($depositRefNo) && !is_string($depositRefNo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($depositRefNo)), __LINE__);
        }
        $this->depositRefNo = $depositRefNo;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\DepositCreditUpdate
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
