<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CustFaultLog StructType
 * @subpackage Structs
 */
class CustFaultLog extends AbstractStructBase
{
    /**
     * The custDetail
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\CustDetail
     */
    public $custDetail;
    /**
     * The faultReport
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\CustFaultReport
     */
    public $faultReport;
    /**
     * The refNo
     * @var string
     */
    public $refNo;
    /**
     * Constructor method for CustFaultLog
     * @uses CustFaultLog::setCustDetail()
     * @uses CustFaultLog::setFaultReport()
     * @uses CustFaultLog::setRefNo()
     * @param \StructType\CustDetail $custDetail
     * @param \StructType\CustFaultReport $faultReport
     * @param string $refNo
     */
    public function __construct(\StructType\CustDetail $custDetail = null, \StructType\CustFaultReport $faultReport = null, $refNo = null)
    {
        $this
            ->setCustDetail($custDetail)
            ->setFaultReport($faultReport)
            ->setRefNo($refNo);
    }
    /**
     * Get custDetail value
     * @return \StructType\CustDetail|null
     */
    public function getCustDetail()
    {
        return $this->custDetail;
    }
    /**
     * Set custDetail value
     * @param \StructType\CustDetail $custDetail
     * @return \StructType\CustFaultLog
     */
    public function setCustDetail(\StructType\CustDetail $custDetail = null)
    {
        $this->custDetail = $custDetail;
        return $this;
    }
    /**
     * Get faultReport value
     * @return \StructType\CustFaultReport|null
     */
    public function getFaultReport()
    {
        return $this->faultReport;
    }
    /**
     * Set faultReport value
     * @param \StructType\CustFaultReport $faultReport
     * @return \StructType\CustFaultLog
     */
    public function setFaultReport(\StructType\CustFaultReport $faultReport = null)
    {
        $this->faultReport = $faultReport;
        return $this;
    }
    /**
     * Get refNo value
     * @return string|null
     */
    public function getRefNo()
    {
        return $this->refNo;
    }
    /**
     * Set refNo value
     * @param string $refNo
     * @return \StructType\CustFaultLog
     */
    public function setRefNo($refNo = null)
    {
        // validation for constraint: string
        if (!is_null($refNo) && !is_string($refNo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($refNo)), __LINE__);
        }
        $this->refNo = $refNo;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\CustFaultLog
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
