<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CancelPayAccountReq StructType
 * @subpackage Structs
 */
class CancelPayAccountReq extends BaseReq
{
    /**
     * The VendingServerId
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $VendingServerId;
    /**
     * The AccountNumber
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $AccountNumber;
    /**
     * The SubAccountNumber
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $SubAccountNumber;
    /**
     * The Amount
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\Currency
     */
    public $Amount;
    /**
     * Constructor method for CancelPayAccountReq
     * @uses CancelPayAccountReq::setVendingServerId()
     * @uses CancelPayAccountReq::setAccountNumber()
     * @uses CancelPayAccountReq::setSubAccountNumber()
     * @uses CancelPayAccountReq::setAmount()
     * @param int $vendingServerId
     * @param string $accountNumber
     * @param string $subAccountNumber
     * @param \StructType\Currency $amount
     */
    public function __construct($vendingServerId = null, $accountNumber = null, $subAccountNumber = null, \StructType\Currency $amount = null)
    {
        $this
            ->setVendingServerId($vendingServerId)
            ->setAccountNumber($accountNumber)
            ->setSubAccountNumber($subAccountNumber)
            ->setAmount($amount);
    }
    /**
     * Get VendingServerId value
     * @return int
     */
    public function getVendingServerId()
    {
        return $this->VendingServerId;
    }
    /**
     * Set VendingServerId value
     * @param int $vendingServerId
     * @return \StructType\CancelPayAccountReq
     */
    public function setVendingServerId($vendingServerId = null)
    {
        // validation for constraint: int
        if (!is_null($vendingServerId) && !is_numeric($vendingServerId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($vendingServerId)), __LINE__);
        }
        $this->VendingServerId = $vendingServerId;
        return $this;
    }
    /**
     * Get AccountNumber value
     * @return string|null
     */
    public function getAccountNumber()
    {
        return $this->AccountNumber;
    }
    /**
     * Set AccountNumber value
     * @param string $accountNumber
     * @return \StructType\CancelPayAccountReq
     */
    public function setAccountNumber($accountNumber = null)
    {
        // validation for constraint: string
        if (!is_null($accountNumber) && !is_string($accountNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($accountNumber)), __LINE__);
        }
        $this->AccountNumber = $accountNumber;
        return $this;
    }
    /**
     * Get SubAccountNumber value
     * @return string|null
     */
    public function getSubAccountNumber()
    {
        return $this->SubAccountNumber;
    }
    /**
     * Set SubAccountNumber value
     * @param string $subAccountNumber
     * @return \StructType\CancelPayAccountReq
     */
    public function setSubAccountNumber($subAccountNumber = null)
    {
        // validation for constraint: string
        if (!is_null($subAccountNumber) && !is_string($subAccountNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($subAccountNumber)), __LINE__);
        }
        $this->SubAccountNumber = $subAccountNumber;
        return $this;
    }
    /**
     * Get Amount value
     * @return \StructType\Currency|null
     */
    public function getAmount()
    {
        return $this->Amount;
    }
    /**
     * Set Amount value
     * @param \StructType\Currency $amount
     * @return \StructType\CancelPayAccountReq
     */
    public function setAmount(\StructType\Currency $amount = null)
    {
        $this->Amount = $amount;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\CancelPayAccountReq
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
