<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfAccountStatus ArrayType
 * @subpackage Arrays
 */
class ArrayOfAccountStatus extends AbstractStructArrayBase
{
    /**
     * The AccountStatus
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\AccountStatus[]
     */
    public $AccountStatus;
    /**
     * Constructor method for ArrayOfAccountStatus
     * @uses ArrayOfAccountStatus::setAccountStatus()
     * @param \StructType\AccountStatus[] $accountStatus
     */
    public function __construct(array $accountStatus = array())
    {
        $this
            ->setAccountStatus($accountStatus);
    }
    /**
     * Get AccountStatus value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\AccountStatus[]|null
     */
    public function getAccountStatus()
    {
        return isset($this->AccountStatus) ? $this->AccountStatus : null;
    }
    /**
     * Set AccountStatus value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\AccountStatus[] $accountStatus
     * @return \ArrayType\ArrayOfAccountStatus
     */
    public function setAccountStatus(array $accountStatus = array())
    {
        foreach ($accountStatus as $arrayOfAccountStatusAccountStatusItem) {
            // validation for constraint: itemType
            if (!$arrayOfAccountStatusAccountStatusItem instanceof \StructType\AccountStatus) {
                throw new \InvalidArgumentException(sprintf('The AccountStatus property can only contain items of \StructType\AccountStatus, "%s" given', is_object($arrayOfAccountStatusAccountStatusItem) ? get_class($arrayOfAccountStatusAccountStatusItem) : gettype($arrayOfAccountStatusAccountStatusItem)), __LINE__);
            }
        }
        if (is_null($accountStatus) || (is_array($accountStatus) && empty($accountStatus))) {
            unset($this->AccountStatus);
        } else {
            $this->AccountStatus = $accountStatus;
        }
        return $this;
    }
    /**
     * Add item to AccountStatus value
     * @throws \InvalidArgumentException
     * @param \StructType\AccountStatus $item
     * @return \ArrayType\ArrayOfAccountStatus
     */
    public function addToAccountStatus(\StructType\AccountStatus $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\AccountStatus) {
            throw new \InvalidArgumentException(sprintf('The AccountStatus property can only contain items of \StructType\AccountStatus, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->AccountStatus[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\AccountStatus|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\AccountStatus|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\AccountStatus|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\AccountStatus|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\AccountStatus|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string AccountStatus
     */
    public function getAttributeName()
    {
        return 'AccountStatus';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfAccountStatus
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
