<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GetHistoryReport StructType
 * @subpackage Structs
 */
class GetHistoryReport extends AbstractStructBase
{
    /**
     * The year
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var int
     */
    public $year;
    /**
     * The clientUserId
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $clientUserId;
    /**
     * The clientPassword
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $clientPassword;
    /**
     * Constructor method for GetHistoryReport
     * @uses GetHistoryReport::setYear()
     * @uses GetHistoryReport::setClientUserId()
     * @uses GetHistoryReport::setClientPassword()
     * @param int $year
     * @param string $clientUserId
     * @param string $clientPassword
     */
    public function __construct($year = null, $clientUserId = null, $clientPassword = null)
    {
        $this
            ->setYear($year)
            ->setClientUserId($clientUserId)
            ->setClientPassword($clientPassword);
    }
    /**
     * Get year value
     * @return int
     */
    public function getYear()
    {
        return $this->year;
    }
    /**
     * Set year value
     * @param int $year
     * @return \StructType\GetHistoryReport
     */
    public function setYear($year = null)
    {
        // validation for constraint: int
        if (!is_null($year) && !is_numeric($year)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($year)), __LINE__);
        }
        $this->year = $year;
        return $this;
    }
    /**
     * Get clientUserId value
     * @return string|null
     */
    public function getClientUserId()
    {
        return $this->clientUserId;
    }
    /**
     * Set clientUserId value
     * @param string $clientUserId
     * @return \StructType\GetHistoryReport
     */
    public function setClientUserId($clientUserId = null)
    {
        // validation for constraint: string
        if (!is_null($clientUserId) && !is_string($clientUserId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($clientUserId)), __LINE__);
        }
        $this->clientUserId = $clientUserId;
        return $this;
    }
    /**
     * Get clientPassword value
     * @return string|null
     */
    public function getClientPassword()
    {
        return $this->clientPassword;
    }
    /**
     * Set clientPassword value
     * @param string $clientPassword
     * @return \StructType\GetHistoryReport
     */
    public function setClientPassword($clientPassword = null)
    {
        // validation for constraint: string
        if (!is_null($clientPassword) && !is_string($clientPassword)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($clientPassword)), __LINE__);
        }
        $this->clientPassword = $clientPassword;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\GetHistoryReport
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
