<?php
/**
 * This file aims to show you how to use this generated package.
 * In addition, the goal is to show which methods are available and the fist needed parameter(s)
 * You have to use an associative array such as:
 * - the key must be a constant beginning with WSDL_ from AbstractSoapClientbase class each generated ServiceType class extends this class
 * - the value must be the corresponding key value (each option matches a {@link http://www.php.net/manual/en/soapclient.soapclient.php} option)
 * $options = array(
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'https://datamanager.ets.org/edmwebservice/edmpraxis.wsdl',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_TRACE => true,
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_LOGIN => 'you_secret_login',
 * \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_PASSWORD => 'you_secret_password',
 * );
 * etc....
 */
require_once __DIR__ . '/vendor/autoload.php';
/**
 * Minimal options
 */
$options = array(
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_URL => 'https://datamanager.ets.org/edmwebservice/edmpraxis.wsdl',
    \WsdlToPhp\PackageBase\AbstractSoapClientBase::WSDL_CLASSMAP => ClassMap::get(),
);
/**
 * Samples for Get ServiceType
 */
$get = new \ServiceType\Get($options);
/**
 * Sample call for GetScoreReportsInCDScoreLinkFormat operation/method
 */
if ($get->GetScoreReportsInCDScoreLinkFormat(new \StructType\GetScoreReportsInCDScoreLinkFormat()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetHistoryReport operation/method
 */
if ($get->GetHistoryReport(new \StructType\GetHistoryReport()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetHistoryReportGivenCandidate operation/method
 */
if ($get->GetHistoryReportGivenCandidate(new \StructType\GetHistoryReportGivenCandidate()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetNewScoreReports operation/method
 */
if ($get->GetNewScoreReports(new \StructType\GetNewScoreReports()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetReportingDates operation/method
 */
if ($get->GetReportingDates(new \StructType\GetReportingDates()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
/**
 * Sample call for GetScoreReportsGivenReportingDate operation/method
 */
if ($get->GetScoreReportsGivenReportingDate(new \StructType\GetScoreReportsGivenReportingDate()) !== false) {
    print_r($get->getResult());
} else {
    print_r($get->getLastError());
}
