<?php

namespace Macellan\EFinans\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for wsLogin StructType
 * Meta informations extracted from the WSDL
 * - type: tns:wsLogin
 * @package UserService
 * @subpackage Structs
 */
class UserServiceWsLogin extends AbstractStructBase
{
    /**
     * The userId
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $userId;
    /**
     * The password
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $password;
    /**
     * The lang
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $lang;
    /**
     * Constructor method for wsLogin
     * @uses UserServiceWsLogin::setUserId()
     * @uses UserServiceWsLogin::setPassword()
     * @uses UserServiceWsLogin::setLang()
     * @param string $userId
     * @param string $password
     * @param string $lang
     */
    public function __construct($userId = null, $password = null, $lang = null)
    {
        $this
            ->setUserId($userId)
            ->setPassword($password)
            ->setLang($lang);
    }
    /**
     * Get userId value
     * @return string|null
     */
    public function getUserId()
    {
        return $this->userId;
    }
    /**
     * Set userId value
     * @param string $userId
     * @return \Macellan\EFinans\StructType\UserServiceWsLogin
     */
    public function setUserId($userId = null)
    {
        // validation for constraint: string
        if (!is_null($userId) && !is_string($userId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($userId)), __LINE__);
        }
        $this->userId = $userId;
        return $this;
    }
    /**
     * Get password value
     * @return string|null
     */
    public function getPassword()
    {
        return $this->password;
    }
    /**
     * Set password value
     * @param string $password
     * @return \Macellan\EFinans\StructType\UserServiceWsLogin
     */
    public function setPassword($password = null)
    {
        // validation for constraint: string
        if (!is_null($password) && !is_string($password)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($password)), __LINE__);
        }
        $this->password = $password;
        return $this;
    }
    /**
     * Get lang value
     * @return string|null
     */
    public function getLang()
    {
        return $this->lang;
    }
    /**
     * Set lang value
     * @param string $lang
     * @return \Macellan\EFinans\StructType\UserServiceWsLogin
     */
    public function setLang($lang = null)
    {
        // validation for constraint: string
        if (!is_null($lang) && !is_string($lang)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($lang)), __LINE__);
        }
        $this->lang = $lang;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Macellan\EFinans\StructType\UserServiceWsLogin
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
