<?php

namespace Macellan\EFinans\ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for all operations
 * @package UserService
 * @subpackage Services
 */
class UserServiceService extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named wsLogin
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Macellan\EFinans\StructType\UserServiceWsLogin $parameters
     * @return \Macellan\EFinans\StructType\UserServiceWsLoginResponse|bool
     */
    public function wsLogin(\Macellan\EFinans\StructType\UserServiceWsLogin $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->wsLogin($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named logout
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \Macellan\EFinans\StructType\UserServiceLogout $parameters
     * @return \Macellan\EFinans\StructType\UserServiceLogoutResponse|bool
     */
    public function logout(\Macellan\EFinans\StructType\UserServiceLogout $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->logout($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \Macellan\EFinans\StructType\UserServiceLogoutResponse|\Macellan\EFinans\StructType\UserServiceWsLoginResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
