<?php

namespace Aap;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ConversionRate StructType
 * @subpackage Structs
 */
class ConversionRate extends AbstractStructBase
{
    /**
     * The FromCurrency
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $FromCurrency;
    /**
     * The ToCurrency
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $ToCurrency;
    /**
     * Constructor method for ConversionRate
     * @uses ConversionRate::setFromCurrency()
     * @uses ConversionRate::setToCurrency()
     * @param string $fromCurrency
     * @param string $toCurrency
     */
    public function __construct($fromCurrency = null, $toCurrency = null)
    {
        $this
            ->setFromCurrency($fromCurrency)
            ->setToCurrency($toCurrency);
    }
    /**
     * Get FromCurrency value
     * @return string
     */
    public function getFromCurrency()
    {
        return $this->FromCurrency;
    }
    /**
     * Set FromCurrency value
     * @uses \Aap\Currency::valueIsValid()
     * @uses \Aap\Currency::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $fromCurrency
     * @return \Aap\ConversionRate
     */
    public function setFromCurrency($fromCurrency = null)
    {
        // validation for constraint: enumeration
        if (!\Aap\Currency::valueIsValid($fromCurrency)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $fromCurrency, implode(', ', \Aap\Currency::getValidValues())), __LINE__);
        }
        $this->FromCurrency = $fromCurrency;
        return $this;
    }
    /**
     * Get ToCurrency value
     * @return string
     */
    public function getToCurrency()
    {
        return $this->ToCurrency;
    }
    /**
     * Set ToCurrency value
     * @uses \Aap\Currency::valueIsValid()
     * @uses \Aap\Currency::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $toCurrency
     * @return \Aap\ConversionRate
     */
    public function setToCurrency($toCurrency = null)
    {
        // validation for constraint: enumeration
        if (!\Aap\Currency::valueIsValid($toCurrency)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $toCurrency, implode(', ', \Aap\Currency::getValidValues())), __LINE__);
        }
        $this->ToCurrency = $toCurrency;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \Aap\ConversionRate
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
