<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for WebAccessSettings StructType
 * @subpackage Structs
 */
class WebAccessSettings extends Item
{
    /**
     * The timezone
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $timezone;
    /**
     * The timezoneId
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $timezoneId;
    /**
     * The timezoneMatches
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $timezoneMatches;
    /**
     * The language
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $language;
    /**
     * The general
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $general;
    /**
     * Constructor method for WebAccessSettings
     * @uses WebAccessSettings::setTimezone()
     * @uses WebAccessSettings::setTimezoneId()
     * @uses WebAccessSettings::setTimezoneMatches()
     * @uses WebAccessSettings::setLanguage()
     * @uses WebAccessSettings::setGeneral()
     * @param string $timezone
     * @param int $timezoneId
     * @param string $timezoneMatches
     * @param string $language
     * @param string $general
     */
    public function __construct($timezone = null, $timezoneId = null, $timezoneMatches = null, $language = null, $general = null)
    {
        $this
            ->setTimezone($timezone)
            ->setTimezoneId($timezoneId)
            ->setTimezoneMatches($timezoneMatches)
            ->setLanguage($language)
            ->setGeneral($general);
    }
    /**
     * Get timezone value
     * @return string|null
     */
    public function getTimezone()
    {
        return $this->timezone;
    }
    /**
     * Set timezone value
     * @param string $timezone
     * @return \StructType\WebAccessSettings
     */
    public function setTimezone($timezone = null)
    {
        // validation for constraint: string
        if (!is_null($timezone) && !is_string($timezone)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($timezone)), __LINE__);
        }
        $this->timezone = $timezone;
        return $this;
    }
    /**
     * Get timezoneId value
     * @return int|null
     */
    public function getTimezoneId()
    {
        return $this->timezoneId;
    }
    /**
     * Set timezoneId value
     * @param int $timezoneId
     * @return \StructType\WebAccessSettings
     */
    public function setTimezoneId($timezoneId = null)
    {
        // validation for constraint: int
        if (!is_null($timezoneId) && !is_numeric($timezoneId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($timezoneId)), __LINE__);
        }
        $this->timezoneId = $timezoneId;
        return $this;
    }
    /**
     * Get timezoneMatches value
     * @return string|null
     */
    public function getTimezoneMatches()
    {
        return $this->timezoneMatches;
    }
    /**
     * Set timezoneMatches value
     * @param string $timezoneMatches
     * @return \StructType\WebAccessSettings
     */
    public function setTimezoneMatches($timezoneMatches = null)
    {
        // validation for constraint: string
        if (!is_null($timezoneMatches) && !is_string($timezoneMatches)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($timezoneMatches)), __LINE__);
        }
        $this->timezoneMatches = $timezoneMatches;
        return $this;
    }
    /**
     * Get language value
     * @return string|null
     */
    public function getLanguage()
    {
        return $this->language;
    }
    /**
     * Set language value
     * @param string $language
     * @return \StructType\WebAccessSettings
     */
    public function setLanguage($language = null)
    {
        // validation for constraint: string
        if (!is_null($language) && !is_string($language)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($language)), __LINE__);
        }
        $this->language = $language;
        return $this;
    }
    /**
     * Get general value
     * @return string|null
     */
    public function getGeneral()
    {
        return $this->general;
    }
    /**
     * Set general value
     * @param string $general
     * @return \StructType\WebAccessSettings
     */
    public function setGeneral($general = null)
    {
        // validation for constraint: string
        if (!is_null($general) && !is_string($general)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($general)), __LINE__);
        }
        $this->general = $general;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\WebAccessSettings
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
