<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Version StructType
 * @subpackage Structs
 */
class Version extends ContainerItem
{
    /**
     * The library
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\NameAndEmail
     */
    public $library;
    /**
     * The documentNumber
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $documentNumber;
    /**
     * The versionCreator
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\NameAndEmail
     */
    public $versionCreator;
    /**
     * The retrievedBy
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\NameAndEmail
     */
    public $retrievedBy;
    /**
     * The retrievedDate
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $retrievedDate;
    /**
     * The versionNumber
     * @var int
     */
    public $versionNumber;
    /**
     * The versionDescription
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $versionDescription;
    /**
     * The versionStatus
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $versionStatus;
    /**
     * The life
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $life;
    /**
     * The ageAction
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $ageAction;
    /**
     * The fileSize
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $fileSize;
    /**
     * The filename
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $filename;
    /**
     * Constructor method for Version
     * @uses Version::setLibrary()
     * @uses Version::setDocumentNumber()
     * @uses Version::setVersionCreator()
     * @uses Version::setRetrievedBy()
     * @uses Version::setRetrievedDate()
     * @uses Version::setVersionNumber()
     * @uses Version::setVersionDescription()
     * @uses Version::setVersionStatus()
     * @uses Version::setLife()
     * @uses Version::setAgeAction()
     * @uses Version::setFileSize()
     * @uses Version::setFilename()
     * @param \StructType\NameAndEmail $library
     * @param int $documentNumber
     * @param \StructType\NameAndEmail $versionCreator
     * @param \StructType\NameAndEmail $retrievedBy
     * @param string $retrievedDate
     * @param int $versionNumber
     * @param string $versionDescription
     * @param string $versionStatus
     * @param int $life
     * @param string $ageAction
     * @param int $fileSize
     * @param string $filename
     */
    public function __construct(\StructType\NameAndEmail $library = null, $documentNumber = null, \StructType\NameAndEmail $versionCreator = null, \StructType\NameAndEmail $retrievedBy = null, $retrievedDate = null, $versionNumber = null, $versionDescription = null, $versionStatus = null, $life = null, $ageAction = null, $fileSize = null, $filename = null)
    {
        $this
            ->setLibrary($library)
            ->setDocumentNumber($documentNumber)
            ->setVersionCreator($versionCreator)
            ->setRetrievedBy($retrievedBy)
            ->setRetrievedDate($retrievedDate)
            ->setVersionNumber($versionNumber)
            ->setVersionDescription($versionDescription)
            ->setVersionStatus($versionStatus)
            ->setLife($life)
            ->setAgeAction($ageAction)
            ->setFileSize($fileSize)
            ->setFilename($filename);
    }
    /**
     * Get library value
     * @return \StructType\NameAndEmail|null
     */
    public function getLibrary()
    {
        return $this->library;
    }
    /**
     * Set library value
     * @param \StructType\NameAndEmail $library
     * @return \StructType\Version
     */
    public function setLibrary(\StructType\NameAndEmail $library = null)
    {
        $this->library = $library;
        return $this;
    }
    /**
     * Get documentNumber value
     * @return int|null
     */
    public function getDocumentNumber()
    {
        return $this->documentNumber;
    }
    /**
     * Set documentNumber value
     * @param int $documentNumber
     * @return \StructType\Version
     */
    public function setDocumentNumber($documentNumber = null)
    {
        // validation for constraint: int
        if (!is_null($documentNumber) && !is_numeric($documentNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($documentNumber)), __LINE__);
        }
        $this->documentNumber = $documentNumber;
        return $this;
    }
    /**
     * Get versionCreator value
     * @return \StructType\NameAndEmail|null
     */
    public function getVersionCreator()
    {
        return $this->versionCreator;
    }
    /**
     * Set versionCreator value
     * @param \StructType\NameAndEmail $versionCreator
     * @return \StructType\Version
     */
    public function setVersionCreator(\StructType\NameAndEmail $versionCreator = null)
    {
        $this->versionCreator = $versionCreator;
        return $this;
    }
    /**
     * Get retrievedBy value
     * @return \StructType\NameAndEmail|null
     */
    public function getRetrievedBy()
    {
        return $this->retrievedBy;
    }
    /**
     * Set retrievedBy value
     * @param \StructType\NameAndEmail $retrievedBy
     * @return \StructType\Version
     */
    public function setRetrievedBy(\StructType\NameAndEmail $retrievedBy = null)
    {
        $this->retrievedBy = $retrievedBy;
        return $this;
    }
    /**
     * Get retrievedDate value
     * @return string|null
     */
    public function getRetrievedDate()
    {
        return $this->retrievedDate;
    }
    /**
     * Set retrievedDate value
     * @param string $retrievedDate
     * @return \StructType\Version
     */
    public function setRetrievedDate($retrievedDate = null)
    {
        // validation for constraint: string
        if (!is_null($retrievedDate) && !is_string($retrievedDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($retrievedDate)), __LINE__);
        }
        $this->retrievedDate = $retrievedDate;
        return $this;
    }
    /**
     * Get versionNumber value
     * @return int|null
     */
    public function getVersionNumber()
    {
        return $this->versionNumber;
    }
    /**
     * Set versionNumber value
     * @param int $versionNumber
     * @return \StructType\Version
     */
    public function setVersionNumber($versionNumber = null)
    {
        // validation for constraint: int
        if (!is_null($versionNumber) && !is_numeric($versionNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($versionNumber)), __LINE__);
        }
        $this->versionNumber = $versionNumber;
        return $this;
    }
    /**
     * Get versionDescription value
     * @return string|null
     */
    public function getVersionDescription()
    {
        return $this->versionDescription;
    }
    /**
     * Set versionDescription value
     * @param string $versionDescription
     * @return \StructType\Version
     */
    public function setVersionDescription($versionDescription = null)
    {
        // validation for constraint: string
        if (!is_null($versionDescription) && !is_string($versionDescription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($versionDescription)), __LINE__);
        }
        $this->versionDescription = $versionDescription;
        return $this;
    }
    /**
     * Get versionStatus value
     * @return string|null
     */
    public function getVersionStatus()
    {
        return $this->versionStatus;
    }
    /**
     * Set versionStatus value
     * @uses \EnumType\VersionStatus::valueIsValid()
     * @uses \EnumType\VersionStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $versionStatus
     * @return \StructType\Version
     */
    public function setVersionStatus($versionStatus = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\VersionStatus::valueIsValid($versionStatus)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $versionStatus, implode(', ', \EnumType\VersionStatus::getValidValues())), __LINE__);
        }
        $this->versionStatus = $versionStatus;
        return $this;
    }
    /**
     * Get life value
     * @return int|null
     */
    public function getLife()
    {
        return $this->life;
    }
    /**
     * Set life value
     * @param int $life
     * @return \StructType\Version
     */
    public function setLife($life = null)
    {
        // validation for constraint: int
        if (!is_null($life) && !is_numeric($life)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($life)), __LINE__);
        }
        $this->life = $life;
        return $this;
    }
    /**
     * Get ageAction value
     * @return string|null
     */
    public function getAgeAction()
    {
        return $this->ageAction;
    }
    /**
     * Set ageAction value
     * @uses \EnumType\AgeAction::valueIsValid()
     * @uses \EnumType\AgeAction::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $ageAction
     * @return \StructType\Version
     */
    public function setAgeAction($ageAction = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\AgeAction::valueIsValid($ageAction)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $ageAction, implode(', ', \EnumType\AgeAction::getValidValues())), __LINE__);
        }
        $this->ageAction = $ageAction;
        return $this;
    }
    /**
     * Get fileSize value
     * @return int|null
     */
    public function getFileSize()
    {
        return $this->fileSize;
    }
    /**
     * Set fileSize value
     * @param int $fileSize
     * @return \StructType\Version
     */
    public function setFileSize($fileSize = null)
    {
        // validation for constraint: int
        if (!is_null($fileSize) && !is_numeric($fileSize)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($fileSize)), __LINE__);
        }
        $this->fileSize = $fileSize;
        return $this;
    }
    /**
     * Get filename value
     * @return string|null
     */
    public function getFilename()
    {
        return $this->filename;
    }
    /**
     * Set filename value
     * @param string $filename
     * @return \StructType\Version
     */
    public function setFilename($filename = null)
    {
        // validation for constraint: string
        if (!is_null($filename) && !is_string($filename)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($filename)), __LINE__);
        }
        $this->filename = $filename;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Version
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
