<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for UserInfo StructType
 * @subpackage Structs
 */
class UserInfo extends AbstractStructBase
{
    /**
     * The name
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - ref: tns:name
     * @var string
     */
    public $name;
    /**
     * The email
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - ref: tns:email
     * @var string
     */
    public $email;
    /**
     * The uuid
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - ref: tns:uuid
     * - documentation: The UUID is the unique user ID on a given email system. This is used in various places to indicate that a sender or recipient is an user internal to the collaboration system instead of an external user (i.e. internet address).
     * @var string
     */
    public $uuid;
    /**
     * The userid
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $userid;
    /**
     * The domain
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $domain;
    /**
     * The postOffice
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $postOffice;
    /**
     * The system
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $system;
    /**
     * The fid
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $fid;
    /**
     * The recipType
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $recipType;
    /**
     * The disabled
     * @var bool
     */
    public $disabled;
    /**
     * Constructor method for UserInfo
     * @uses UserInfo::setName()
     * @uses UserInfo::setEmail()
     * @uses UserInfo::setUuid()
     * @uses UserInfo::setUserid()
     * @uses UserInfo::setDomain()
     * @uses UserInfo::setPostOffice()
     * @uses UserInfo::setSystem()
     * @uses UserInfo::setFid()
     * @uses UserInfo::setRecipType()
     * @uses UserInfo::setDisabled()
     * @param string $name
     * @param string $email
     * @param string $uuid
     * @param string $userid
     * @param string $domain
     * @param string $postOffice
     * @param string $system
     * @param string $fid
     * @param string $recipType
     * @param bool $disabled
     */
    public function __construct($name = null, $email = null, $uuid = null, $userid = null, $domain = null, $postOffice = null, $system = null, $fid = null, $recipType = null, $disabled = null)
    {
        $this
            ->setName($name)
            ->setEmail($email)
            ->setUuid($uuid)
            ->setUserid($userid)
            ->setDomain($domain)
            ->setPostOffice($postOffice)
            ->setSystem($system)
            ->setFid($fid)
            ->setRecipType($recipType)
            ->setDisabled($disabled);
    }
    /**
     * Get name value
     * @return string|null
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return \StructType\UserInfo
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($name)), __LINE__);
        }
        $this->name = $name;
        return $this;
    }
    /**
     * Get email value
     * @return string|null
     */
    public function getEmail()
    {
        return $this->email;
    }
    /**
     * Set email value
     * @param string $email
     * @return \StructType\UserInfo
     */
    public function setEmail($email = null)
    {
        // validation for constraint: string
        if (!is_null($email) && !is_string($email)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($email)), __LINE__);
        }
        $this->email = $email;
        return $this;
    }
    /**
     * Get uuid value
     * @return string|null
     */
    public function getUuid()
    {
        return $this->uuid;
    }
    /**
     * Set uuid value
     * @param string $uuid
     * @return \StructType\UserInfo
     */
    public function setUuid($uuid = null)
    {
        // validation for constraint: string
        if (!is_null($uuid) && !is_string($uuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($uuid)), __LINE__);
        }
        $this->uuid = $uuid;
        return $this;
    }
    /**
     * Get userid value
     * @return string|null
     */
    public function getUserid()
    {
        return $this->userid;
    }
    /**
     * Set userid value
     * @param string $userid
     * @return \StructType\UserInfo
     */
    public function setUserid($userid = null)
    {
        // validation for constraint: string
        if (!is_null($userid) && !is_string($userid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($userid)), __LINE__);
        }
        $this->userid = $userid;
        return $this;
    }
    /**
     * Get domain value
     * @return string|null
     */
    public function getDomain()
    {
        return $this->domain;
    }
    /**
     * Set domain value
     * @param string $domain
     * @return \StructType\UserInfo
     */
    public function setDomain($domain = null)
    {
        // validation for constraint: string
        if (!is_null($domain) && !is_string($domain)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($domain)), __LINE__);
        }
        $this->domain = $domain;
        return $this;
    }
    /**
     * Get postOffice value
     * @return string|null
     */
    public function getPostOffice()
    {
        return $this->postOffice;
    }
    /**
     * Set postOffice value
     * @param string $postOffice
     * @return \StructType\UserInfo
     */
    public function setPostOffice($postOffice = null)
    {
        // validation for constraint: string
        if (!is_null($postOffice) && !is_string($postOffice)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($postOffice)), __LINE__);
        }
        $this->postOffice = $postOffice;
        return $this;
    }
    /**
     * Get system value
     * @return string|null
     */
    public function getSystem()
    {
        return $this->system;
    }
    /**
     * Set system value
     * @param string $system
     * @return \StructType\UserInfo
     */
    public function setSystem($system = null)
    {
        // validation for constraint: string
        if (!is_null($system) && !is_string($system)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($system)), __LINE__);
        }
        $this->system = $system;
        return $this;
    }
    /**
     * Get fid value
     * @return string|null
     */
    public function getFid()
    {
        return $this->fid;
    }
    /**
     * Set fid value
     * @param string $fid
     * @return \StructType\UserInfo
     */
    public function setFid($fid = null)
    {
        // validation for constraint: string
        if (!is_null($fid) && !is_string($fid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($fid)), __LINE__);
        }
        $this->fid = $fid;
        return $this;
    }
    /**
     * Get recipType value
     * @return string|null
     */
    public function getRecipType()
    {
        return $this->recipType;
    }
    /**
     * Set recipType value
     * @uses \EnumType\RecipientType::valueIsValid()
     * @uses \EnumType\RecipientType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $recipType
     * @return \StructType\UserInfo
     */
    public function setRecipType($recipType = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\RecipientType::valueIsValid($recipType)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $recipType, implode(', ', \EnumType\RecipientType::getValidValues())), __LINE__);
        }
        $this->recipType = $recipType;
        return $this;
    }
    /**
     * Get disabled value
     * @return bool|null
     */
    public function getDisabled()
    {
        return $this->disabled;
    }
    /**
     * Set disabled value
     * @param bool $disabled
     * @return \StructType\UserInfo
     */
    public function setDisabled($disabled = null)
    {
        // validation for constraint: boolean
        if (!is_null($disabled) && !is_bool($disabled)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($disabled)), __LINE__);
        }
        $this->disabled = $disabled;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\UserInfo
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
