<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for unarchiveResponse StructType
 * @subpackage Structs
 */
class UnarchiveResponse extends AbstractStructBase
{
    /**
     * The path
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $path;
    /**
     * The status
     * @var \StructType\Status
     */
    public $status;
    /**
     * Constructor method for unarchiveResponse
     * @uses UnarchiveResponse::setPath()
     * @uses UnarchiveResponse::setStatus()
     * @param string $path
     * @param \StructType\Status $status
     */
    public function __construct($path = null, \StructType\Status $status = null)
    {
        $this
            ->setPath($path)
            ->setStatus($status);
    }
    /**
     * Get path value
     * @return string|null
     */
    public function getPath()
    {
        return $this->path;
    }
    /**
     * Set path value
     * @param string $path
     * @return \StructType\UnarchiveResponse
     */
    public function setPath($path = null)
    {
        // validation for constraint: string
        if (!is_null($path) && !is_string($path)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($path)), __LINE__);
        }
        $this->path = $path;
        return $this;
    }
    /**
     * Get status value
     * @return \StructType\Status|null
     */
    public function getStatus()
    {
        return $this->status;
    }
    /**
     * Set status value
     * @param \StructType\Status $status
     * @return \StructType\UnarchiveResponse
     */
    public function setStatus(\StructType\Status $status = null)
    {
        $this->status = $status;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\UnarchiveResponse
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
