<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TimezoneComponent StructType
 * @subpackage Structs
 */
class TimezoneComponent extends AbstractStructBase
{
    /**
     * The name
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $name;
    /**
     * The month
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - maxInclusive: 11
     * @var string
     */
    public $month;
    /**
     * The day
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - maxInclusive: 30
     * @var string
     */
    public $day;
    /**
     * The dayOfWeek
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var \StructType\DayOfWeek
     */
    public $dayOfWeek;
    /**
     * The hour
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - maxInclusive: 23
     * @var string
     */
    public $hour;
    /**
     * The minute
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - maxInclusive: 59
     * @var string
     */
    public $minute;
    /**
     * The offset
     * Meta informations extracted from the WSDL
     * - documentation: The number of seconds from GMT (UTC)
     * - maxExclusive: 86400
     * - minExclusive: -86400
     * @var int
     */
    public $offset;
    /**
     * Constructor method for TimezoneComponent
     * @uses TimezoneComponent::setName()
     * @uses TimezoneComponent::setMonth()
     * @uses TimezoneComponent::setDay()
     * @uses TimezoneComponent::setDayOfWeek()
     * @uses TimezoneComponent::setHour()
     * @uses TimezoneComponent::setMinute()
     * @uses TimezoneComponent::setOffset()
     * @param string $name
     * @param string $month
     * @param string $day
     * @param \StructType\DayOfWeek $dayOfWeek
     * @param string $hour
     * @param string $minute
     * @param int $offset
     */
    public function __construct($name = null, $month = null, $day = null, \StructType\DayOfWeek $dayOfWeek = null, $hour = null, $minute = null, $offset = null)
    {
        $this
            ->setName($name)
            ->setMonth($month)
            ->setDay($day)
            ->setDayOfWeek($dayOfWeek)
            ->setHour($hour)
            ->setMinute($minute)
            ->setOffset($offset);
    }
    /**
     * Get name value
     * @return string|null
     */
    public function getName()
    {
        return $this->name;
    }
    /**
     * Set name value
     * @param string $name
     * @return \StructType\TimezoneComponent
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($name)), __LINE__);
        }
        $this->name = $name;
        return $this;
    }
    /**
     * Get month value
     * @return string|null
     */
    public function getMonth()
    {
        return $this->month;
    }
    /**
     * Set month value
     * @param string $month
     * @return \StructType\TimezoneComponent
     */
    public function setMonth($month = null)
    {
        // validation for constraint: maxInclusive
        if ($month > 11) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be inferior or equal to 11, "%s" given', $month), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($month) && !is_string($month)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($month)), __LINE__);
        }
        $this->month = $month;
        return $this;
    }
    /**
     * Get day value
     * @return string|null
     */
    public function getDay()
    {
        return $this->day;
    }
    /**
     * Set day value
     * @param string $day
     * @return \StructType\TimezoneComponent
     */
    public function setDay($day = null)
    {
        // validation for constraint: maxInclusive
        if ($day > 30) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be inferior or equal to 30, "%s" given', $day), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($day) && !is_string($day)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($day)), __LINE__);
        }
        $this->day = $day;
        return $this;
    }
    /**
     * Get dayOfWeek value
     * @return \StructType\DayOfWeek|null
     */
    public function getDayOfWeek()
    {
        return $this->dayOfWeek;
    }
    /**
     * Set dayOfWeek value
     * @param \StructType\DayOfWeek $dayOfWeek
     * @return \StructType\TimezoneComponent
     */
    public function setDayOfWeek(\StructType\DayOfWeek $dayOfWeek = null)
    {
        $this->dayOfWeek = $dayOfWeek;
        return $this;
    }
    /**
     * Get hour value
     * @return string|null
     */
    public function getHour()
    {
        return $this->hour;
    }
    /**
     * Set hour value
     * @param string $hour
     * @return \StructType\TimezoneComponent
     */
    public function setHour($hour = null)
    {
        // validation for constraint: maxInclusive
        if ($hour > 23) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be inferior or equal to 23, "%s" given', $hour), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($hour) && !is_string($hour)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($hour)), __LINE__);
        }
        $this->hour = $hour;
        return $this;
    }
    /**
     * Get minute value
     * @return string|null
     */
    public function getMinute()
    {
        return $this->minute;
    }
    /**
     * Set minute value
     * @param string $minute
     * @return \StructType\TimezoneComponent
     */
    public function setMinute($minute = null)
    {
        // validation for constraint: maxInclusive
        if ($minute > 59) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be inferior or equal to 59, "%s" given', $minute), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($minute) && !is_string($minute)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($minute)), __LINE__);
        }
        $this->minute = $minute;
        return $this;
    }
    /**
     * Get offset value
     * @return int|null
     */
    public function getOffset()
    {
        return $this->offset;
    }
    /**
     * Set offset value
     * @param int $offset
     * @return \StructType\TimezoneComponent
     */
    public function setOffset($offset = null)
    {
        // validation for constraint: maxExclusive
        if ($offset >= 86400) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be striclty inferior to 86400, "%s" given', $offset), __LINE__);
        }
        // validation for constraint: minExclusive
        if ($offset <= -86400) {
            throw new \InvalidArgumentException(sprintf('Invalid value, the value must be strictly superior to -86400, "%s" given', $offset), __LINE__);
        }
        // validation for constraint: int
        if (!is_null($offset) && !is_numeric($offset)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($offset)), __LINE__);
        }
        $this->offset = $offset;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\TimezoneComponent
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
