<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Timezone StructType
 * @subpackage Structs
 */
class Timezone extends AbstractStructBase
{
    /**
     * The id
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $id;
    /**
     * The description
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - ref: tns:description
     * @var string
     */
    public $description;
    /**
     * The daylight
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\TimezoneComponent
     */
    public $daylight;
    /**
     * The standard
     * Meta informations extracted from the WSDL
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\TimezoneComponent
     */
    public $standard;
    /**
     * Constructor method for Timezone
     * @uses Timezone::setId()
     * @uses Timezone::setDescription()
     * @uses Timezone::setDaylight()
     * @uses Timezone::setStandard()
     * @param string $id
     * @param string $description
     * @param \StructType\TimezoneComponent $daylight
     * @param \StructType\TimezoneComponent $standard
     */
    public function __construct($id = null, $description = null, \StructType\TimezoneComponent $daylight = null, \StructType\TimezoneComponent $standard = null)
    {
        $this
            ->setId($id)
            ->setDescription($description)
            ->setDaylight($daylight)
            ->setStandard($standard);
    }
    /**
     * Get id value
     * @return string|null
     */
    public function getId()
    {
        return $this->id;
    }
    /**
     * Set id value
     * @param string $id
     * @return \StructType\Timezone
     */
    public function setId($id = null)
    {
        // validation for constraint: string
        if (!is_null($id) && !is_string($id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($id)), __LINE__);
        }
        $this->id = $id;
        return $this;
    }
    /**
     * Get description value
     * @return string|null
     */
    public function getDescription()
    {
        return $this->description;
    }
    /**
     * Set description value
     * @param string $description
     * @return \StructType\Timezone
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($description)), __LINE__);
        }
        $this->description = $description;
        return $this;
    }
    /**
     * Get daylight value
     * @return \StructType\TimezoneComponent|null
     */
    public function getDaylight()
    {
        return $this->daylight;
    }
    /**
     * Set daylight value
     * @param \StructType\TimezoneComponent $daylight
     * @return \StructType\Timezone
     */
    public function setDaylight(\StructType\TimezoneComponent $daylight = null)
    {
        $this->daylight = $daylight;
        return $this;
    }
    /**
     * Get standard value
     * @return \StructType\TimezoneComponent|null
     */
    public function getStandard()
    {
        return $this->standard;
    }
    /**
     * Set standard value
     * @param \StructType\TimezoneComponent $standard
     * @return \StructType\Timezone
     */
    public function setStandard(\StructType\TimezoneComponent $standard = null)
    {
        $this->standard = $standard;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\Timezone
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
